<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class CacheCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'som:cache';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command handle clean cache application';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        Artisan::call("config:clear");
        Artisan::call("view:clear");
        Artisan::call("cache:clear");
        Artisan::call("route:clear");
        Artisan::call("clear-compiled");
        Artisan::call('optimize');
        Artisan::call("config:cache");
        $this->info('You are running the config view cache route clear-compiled optimize clear');
        $this->comment('Performing some processing here');
        $this->info('The command has been successfully executed');
    }
}
