<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class CreatePermissionCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'som:permission';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command handle create or update permission application';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        Artisan::call('db:seed --class=PermissionSeeder');
        $this->info('You are running the create or update permission');
        $this->comment('Performing some processing here');
        $this->info('The command has been successfully executed');
        return 0;
    }
}
