<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class PreparDeployCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'som:deploy';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command run prepare before deploy';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('You are running the command prepare deploy');
        $this->comment('Performing some processing here');
        shell_exec('composer install --optimize-autoloader --no-dev');
        Artisan::call('config:cache');
        Artisan::call('route:cache');
        Artisan::call('view:cache');
        $this->info('The command has been successfully executed');
        return 0;
    }
}
