<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Validator;
use Spatie\Permission\Models\Role;

class SyncRoleCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'som:sync-role {--role=} {--user=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command handle sync role to user';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $role = $this->option('role');
        $user = $this->option('user');
        $this->info('You are running the create or update permission');
        $this->comment('Performing some processing here');
        if($role && $user){
            $validator = Validator::make([
                'role' => $role,
                'user' => $user,
            ], [
                'role' => ['exists:roles,id'],
                'user' => ['exists:users,id'],
            ]);
            if ($validator->fails()) {
                foreach ($validator->errors()->all() as $error) {
                    $this->error($error);
                }
                return 0;
            }

            $role = Role::find($role);
            $user = User::find($user);
            $user->syncRoles($role->id);
            $this->info("The command has been successfully executed role:{$role->name} to user:{$user->name}");
        }else if($role){
            $validator = Validator::make([
                'role' => $role,
            ], [
                'role' => ['exists:roles,id'],
            ]);
            if ($validator->fails()) {
                foreach ($validator->errors()->all() as $error) {
                    $this->error($error);
                }
                return 0;
            }
            $user = User::find(1);
            $role = Role::find($role);
            $user->syncRoles($role);
            $this->info("The command has been successfully executed role:{$role->name} to user:{$user->name}");
        }else if($user){
            $validator = Validator::make([
                'user' => $user,
            ], [
                'user' => ['exists:users,id'],
            ]);
            if ($validator->fails()) {
                foreach ($validator->errors()->all() as $error) {
                    $this->error($error);
                }
                return 0;
            }
            $role = Role::find(1);
            $user = User::find($user);
            $user->syncRoles($role->id);
            $this->info("The command has been successfully executed role:{$role->name} to user:{$user->name}");
        }else{
            $validator = Validator::make([
                'role' => 1,
                'user' => 1,
            ], [
                'role' => ['exists:roles,id'],
                'user' => ['exists:users,id'],
            ]);
            if ($validator->fails()) {
                foreach ($validator->errors()->all() as $error) {
                    $this->error($error);
                }
                return 0;
            }
            $role = Role::find(1);
            $user = User::find(1);
            $user->syncRoles(1);
            $this->info("The command has been successfully executed role:{$role->name} to user:{$user->name}");
        }
        return 0;
    }
}
