<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use App\Http\Controllers\Admin\ScheduleRunController;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('som:cache');
        // $schedule->command('som:permission');
        // $schedule->command('som:sync-role');
        // $schedule->command('som:deploy');

        $schedule->call(function(){
            ScheduleRunController::AutoUpdateLoanToWriteOff();
        })->dailyAt('00:00')->runInBackground();
        $schedule->command('backup:clean',['--disable-notifications'])->dailyAt('00:20')->runInBackground();
        $schedule->command('backup:run', ['--only-db','--disable-notifications'])->dailyAt('00:20')->runInBackground();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
