<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;

class ExportCollected implements FromCollection, WithHeadings, WithEvents, ShouldAutoSize,WithColumnFormatting
{
    function __construct($data)
    {
        $this->data = $data;
    }
    public function collection()
    {
        // dd($this->data);
        $output = [];
        foreach ($this->data as $key => $val)
	    {
	      $output[] = [ 
            $key+1,
            $val->client_name,
            $val->client_phone,
            $val->co_name,
            date('d-m-Y', strtotime($val->received_date)),
            $val->paid_principal,
            $val->paid_interest,
            $val->paid_risk,
            $val->paid_maintenance,
            $val->received,
            $val->paid_penalty,
	      ];
	    }
	    return collect($output);
    }

    public function columnFormats(): array
    {
        return [
            'C' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'D' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'E' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'F' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'G' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'H' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'I' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'J' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'K' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'L' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'M' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'N' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'O' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'P' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'Q' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'R' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'S' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
        ];
    }

    public function registerEvents(): array
    {
        
        $styleArray = [
            'font' => [
                'color' => array('rgb' => '000000'),
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['rgb' => '000000'],
                ],
            ],
        ];
        
        return [
            AfterSheet::class    => function(AfterSheet $event) use ($styleArray)
            {
                $cellRange = 'A1:K1'; // All headers
                $event->sheet->getDelegate()->getStyle($cellRange)->getFont()->setSize(14);
                $event->sheet->getStyle($cellRange)->ApplyFromArray($styleArray);
                for ($i = 1; $i <= count($this->data) + 2; $i++) {
                    $event->sheet->getStyle("A$i:K$i")->ApplyFromArray([
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['rgb' => '000000'],
                            ],
                        ],
                    ]);
                }
                $total_principal = 0;
                $total_interest = 0;
                $total_received = 0;
                $total_penalty = 0;
                $total_risk = 0;
                $total_maintenance = 0;
                foreach ($this->data as $key => $value) {
                    $total_principal += $value->paid_principal;
                    $total_interest += $value->paid_interest;
                    $total_received += $value->received;
                    $total_penalty += $value->paid_penalty;
                    $total_risk += $value->paid_risk;
                    $total_maintenance += $value->paid_maintenance;
                }

                // last column as letter value (e.g., D)
                $last_column = Coordinate::stringFromColumnIndex(11);
                // calculate last row + 1 (total results + header rows + column headings row + new row)
                $last_row = count($this->data) + 4;
                // set up a style array for cell formatting
                $style_text_center = [
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical'  => Alignment::VERTICAL_CENTER,
                    ],
                    'font' => [
                        'name' => 'Khmer OS Battambang',
                        'color' => array('rgb' => '000000'),
                        'size'      =>  15,
                        'bold'      =>  true,
                    ],

                ];
                $style_header = [
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical'  => Alignment::VERTICAL_CENTER,
                    ],
                    'font' => [
                        'name' => 'Khmer OS Muol Light',
                        'color' => array('rgb' => 'ffffff'),
                        'size'      =>  15,
                        'bold'      =>  true,
                        // 'background' => [
                        //     'color'=> array('rgb' => 'e1ab23'),
                        // ]
                    ],
        
                ];
                $color = [
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical'  => Alignment::VERTICAL_CENTER,
                    ],
                    'font' => [
                        'name' => 'Khmer OS Battambang',
                        'color' => array('rgb' => 'ffffff'),
                        'size'      =>  15,
                        'bold'      =>  true,
                        // 'background' => [
                        //     'color'=> array('rgb' => 'e1ab23'),
                        // ]
                    ],
        
                ];
                // at row 1, insert 2 rows
                $event->sheet->insertNewRowBefore(1,2);
                // merge cells for full-width
                $event->sheet->mergeCells(sprintf('C1:%s1', $last_column));
                $event->sheet->mergeCells("A1:B1");
                $event->sheet->mergeCells("A2:K2");
                $event->sheet->setCellValue('C1', 'របាយការណ៍បានប្រមូល');

                
                $event->sheet->getRowDimension(1)->setRowHeight(100);
                $event->sheet->setCellValue(sprintf('E%d', $last_row), 'Total');
                $event->sheet->setCellValue(sprintf('F%d', $last_row), number_format($total_principal));
                $event->sheet->setCellValue(sprintf('G%d', $last_row), number_format($total_interest));
                $event->sheet->setCellValue(sprintf('H%d', $last_row), number_format($total_risk));
                $event->sheet->setCellValue(sprintf('I%d', $last_row), number_format($total_maintenance));
                $event->sheet->setCellValue(sprintf('J%d', $last_row), number_format($total_received));
                $event->sheet->setCellValue(sprintf('K%d', $last_row), number_format($total_penalty));

                // align style
                
                $event->sheet->getStyle('A:K')->applyFromArray($style_text_center);
                $event->sheet->getStyle('A1:B1')->applyFromArray($style_text_center);
                $event->sheet->getStyle('C1:K1')->applyFromArray($style_header);
                $event->sheet->getStyle('A3:K3')->applyFromArray($color);
                $event->sheet->getDelegate()->getStyle('C1:K1')
                    ->getFill()
                    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('0c9046');                                       
                $event->sheet->getDelegate()->getStyle('A3:K3')
                    ->getFill()
                    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                    ->getStartColor()
                 ->setARGB('0c9046');
                $event->sheet->getStyle(sprintf('F%d', $last_row), number_format($total_principal))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('G%d', $last_row), number_format($total_interest))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('H%d', $last_row), number_format($total_risk))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('I%d', $last_row), number_format($total_maintenance))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('J%d', $last_row), number_format($total_received))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('K%d', $last_row), number_format($total_penalty))->applyFromArray($style_text_center);
                
                $drawing = new Drawing();
                $drawing->setPath(public_path('/images/logo.png'));
                $drawing->setHeight(100);
                $drawing->setOffsetX(30);
                $drawing->setOffsetY(10);
                $drawing->setCoordinates('A1');
                $drawing->setWorksheet($event->sheet->getDelegate());
            },
        ];
    }

    public function headings(): array
    {
        return [					  								
            'ល.រ',
            'ឈ្មោះអតិថិជន',
            '​លេខទូរស័ព្ទអតិថិជន',
            'ឈ្មោះមន្រ្តីឥណទាន',
            'កាលបរិច្ឆេទទទួល',
            'ប្រាក់ដើម',
            'ការប្រាក់',
            'សេវាប្រតិបត្តិការ',
            'សេវាធានា',
            'ទឹកប្រាក់បានទទួល',
            'ប្រាក់ពិន័យ',
        ];
    }
}
