<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;

class ExportLate implements FromCollection, WithHeadings, WithEvents, ShouldAutoSize,WithColumnFormatting
{
    function __construct($data)
    {
        $this->data = $data;
    }
    public function collection()
    {
        // dd($this->data);
        $output = [];
        foreach ($this->data as $key => $val)
	    {
	      $output[] = [
            $key+1,
            $val->loan_code,
            $val->client_name,
            $val->client_phone,
            $val->co_name,
            $val->village_km,
            date('d-m-Y', strtotime($val->date_late)),
            $val->total_late,
            $val->principal_late,
            $val->interest_late,
            $val->received_late,
            $val->unreceived_late,
            $val->balance_principal,
            number_format(($val->balance_principal/$val->total_balance_principal)*100, 2).'%',
	      ];
	    }
	    return collect($output);
    }

    public function columnFormats(): array
    {
        return [
            'C' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'D' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'E' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'F' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'G' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'H' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'I' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'J' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'K' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'L' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'M' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'N' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'O' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'P' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'Q' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'R' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'S' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
        ];
    }

    public function registerEvents(): array
    {

        $styleArray = [
            'font' => [
                'color' => array('rgb' => '000000'),
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['rgb' => '000000'],
                ],
            ],
        ];

        return [
            AfterSheet::class    => function(AfterSheet $event) use ($styleArray)
            {
                $cellRange = 'A1:O1'; // All headers
                $event->sheet->getDelegate()->getStyle($cellRange)->getFont()->setSize(14);
                $event->sheet->getStyle($cellRange)->ApplyFromArray($styleArray);
                for ($i = 1; $i <= count($this->data) + 2; $i++) {
                    $event->sheet->getStyle("A$i:O$i")->ApplyFromArray([
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['rgb' => '000000'],
                            ],
                        ],
                    ]);
                }
                $total_principal = 0;
                $total_interest = 0;
                $total_received = 0;
                $total_unreceived = 0;
                $total_balance_principal = 0;
                $total_principal_balance = 0;
                $principal_balance = $this->data[0]->total_balance_principal;
                foreach ($this->data as $key => $value) {
                    $total_principal += $value->principal_late;
                    $total_interest += $value->interest_late;
                    $total_received += $value->received_late;
                    $total_unreceived += $value->unreceived_late;
                    $total_balance_principal += $value->balance_principal;
                    $total_principal_balance += ($value->balance_principal/ $principal_balance)*100;


                }

                // last column as letter value (e.g., D)
                $last_column = Coordinate::stringFromColumnIndex(15);
                // calculate last row + 1 (total results + header rows + column headings row + new row)
                $last_row = count($this->data) + 4;
                // set up a style array for cell formatting
                $style_text_center = [
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical'  => Alignment::VERTICAL_CENTER,
                    ],
                    'font' => [
                        'name' => 'Khmer OS Battambang',
                        'color' => array('rgb' => '000000'),
                        'size'      =>  15,
                        'bold'      =>  true,
                    ],

                ];
                $style_header = [
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical'  => Alignment::VERTICAL_CENTER,
                    ],
                    'font' => [
                        'name' => 'Khmer OS Muol Light',
                        'color' => array('rgb' => 'ffffff'),
                        'size'      =>  15,
                        'bold'      =>  true,
                        // 'background' => [
                        //     'color'=> array('rgb' => 'e1ab23'),
                        // ]
                    ],

                ];
                $color = [
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical'  => Alignment::VERTICAL_CENTER,
                    ],
                    'font' => [
                        'name' => 'Khmer OS Battambang',
                        'color' => array('rgb' => 'ffffff'),
                        'size'      =>  15,
                        'bold'      =>  true,
                        // 'background' => [
                        //     'color'=> array('rgb' => 'e1ab23'),
                        // ]
                    ],

                ];
                // at row 1, insert 2 rows
                $event->sheet->insertNewRowBefore(1,2);
                // merge cells for full-width
                $event->sheet->mergeCells(sprintf('C1:%s1', $last_column));
                $event->sheet->mergeCells("A1:B1");
                $event->sheet->mergeCells("A2:O2");
                $event->sheet->setCellValue('C1', 'របាយការណ៍យឺត');


                $event->sheet->getRowDimension(1)->setRowHeight(100);
                $event->sheet->setCellValue(sprintf('H%d', $last_row), 'Total');
                $event->sheet->setCellValue(sprintf('I%d', $last_row), number_format($total_principal,2));
                $event->sheet->setCellValue(sprintf('J%d', $last_row), number_format($total_interest,2));
                $event->sheet->setCellValue(sprintf('K%d', $last_row), number_format($total_received,2));
                $event->sheet->setCellValue(sprintf('L%d', $last_row), number_format($total_unreceived,2));
                $event->sheet->setCellValue(sprintf('M%d', $last_row), number_format($total_balance_principal,2));
                $event->sheet->setCellValue(sprintf('N%d', $last_row), number_format($total_principal_balance,2));

                // align style

                $event->sheet->getStyle('A:O')->applyFromArray($style_text_center);
                $event->sheet->getStyle('A1:B1')->applyFromArray($style_text_center);
                $event->sheet->getStyle('C1:O1')->applyFromArray($style_header);
                $event->sheet->getStyle('A3:O3')->applyFromArray($color);
                $event->sheet->getDelegate()->getStyle('C1:O1')
                    ->getFill()
                    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('0c9046');
                $event->sheet->getDelegate()->getStyle('A3:O3')
                    ->getFill()
                    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                    ->getStartColor()
                 ->setARGB('0c9046');

                $event->sheet->getStyle(sprintf('I%d', $last_row), number_format($total_principal,2))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('J%d', $last_row), number_format($total_interest,2))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('K%d', $last_row), number_format($total_received,2))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('L%d', $last_row), number_format($total_unreceived,2))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('M%d', $last_row), number_format($total_balance_principal,2))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('N%d', $last_row), number_format($total_principal_balance,2))->applyFromArray($style_text_center);

                $drawing = new Drawing();
                $drawing->setPath(public_path('/images/logo.png',2));
                $drawing->setHeight(100);
                $drawing->setOffsetX(30);
                $drawing->setOffsetY(10);
                $drawing->setCoordinates('A1');
                $drawing->setWorksheet($event->sheet->getDelegate());
            },
        ];
    }

    public function headings(): array
    {
        return [
            'ល.រ',
            'លេខកូដកម្ចី',
            'ឈ្មោះអតិថិជន',
            'លេខអតិថិជន',
            'ឈ្មោះមន្រ្តីឥណទាន',
            'ភូមិ',
            'កាលបរិច្ឆេទយឺត',
            'ចំនួនយឺត',
            'ប្រាក់ដើម',
            'ការប្រាក់',
            'បានបង់',
            'មិនទាន់បានបង់',
            'ប្រាក់ដើមនៅជំពាក់សរុប',
            'PAR',
            'បរិយាយ',
        ];
    }
}
