<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;

class ExportLoan implements FromCollection, WithHeadings, WithEvents, ShouldAutoSize,WithColumnFormatting
{
    function __construct($data)
    {
        $this->data = $data;
    }
    public function funTerm($status){
        if($status==1){
            return 'ថ្ងៃ';
        }else if($status==2){
            return 'សប្ដាហ៍';
        }else if($status==3){
            return 'កន្លះខែ';
        }else if($status==4){
            return 'ខែ';
        }
    }
    public function funConditionPay($ConPay,$status){
        if($ConPay==1){
            return 'បង់ប្រចាំ'.$this->funTerm($status).'ថេរ';
        }else if($ConPay==2){
            return 'បង់រំលោះប្រចាំ'.$this->funTerm($status).'ថយ(ដើមថេរ)';
        }else if($ConPay==3){
            return 'បង់ប្រាក់ដើមនិងការប្រាក់ថេរ'.$this->funTerm($status);
        }else if($ConPay==4){
            return 'បង់តែការប្រាក់ប្រចាំ'.$this->funTerm($status);
        }
    }
    public function collection()
    {
        // dd($this->data);
        $output = [];
        foreach ($this->data as $key => $val)
	    {
	      $output[] = [
            $key+1,
            $val->client_name,
            $val->co_name,
            $val->loan_code,
            date('d-m-Y', strtotime($val->installment_date)),
            date('d-m-Y', strtotime($val->start_date)),
            $val->reschedule_amount,
            $val->loan_out,
            $val->service,
            $val->total_service,
            $val->service_collection,
            $val->total_collection,
            $val->saving,
            $val->total_saving,
            $val->interest,
            $val->total_interest,
            $val->loan_receive,
            $val->loan_in,
            $val->loan_balance,
            $val->period,
            $this->funConditionPay($val->condition_pay,$val->term_type),
            $val->loan_status,
	      ];
	    }
	    return collect($output);
    }

    public function columnFormats(): array
    {
        return [
            'C' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'D' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'E' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'F' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'G' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'H' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'I' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'J' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'K' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'L' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'M' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'N' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'O' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'P' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'Q' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'R' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
            'S' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
        ];
    }

    public function registerEvents(): array
    {

        $styleArray = [
            'font' => [
                'color' => array('rgb' => '000000'),
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['rgb' => '000000'],
                ],
            ],
        ];

        return [
            AfterSheet::class    => function(AfterSheet $event) use ($styleArray)
            {
                $cellRange = 'A1:V1'; // All headers
                $event->sheet->getDelegate()->getStyle($cellRange)->getFont()->setSize(14);
                $event->sheet->getStyle($cellRange)->ApplyFromArray($styleArray);
                for ($i = 1; $i <= count($this->data) + 2; $i++) {
                    $event->sheet->getStyle("A$i:V$i")->ApplyFromArray([
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                                'color' => ['rgb' => '000000'],
                            ],
                        ],
                    ]);
                }
                $totalLoanOut = 0;
                $totalService = 0;
                $totalCollection = 0;
                $totalSaving = 0;
                $totalInterest = 0;
                $totalLoanReceived = 0;
                $totalLoanIn = 0;
                $totalLoanBalance = 0;
                foreach ($this->data as $key => $value) {
                    $totalLoanOut += $value->loan_out;
                    $totalService += $value->total_service;
                    $totalCollection += $value->total_collection;
                    $totalSaving += $value->total_saving;
                    $totalInterest += $value->total_interest;
                    $totalLoanReceived += $value->loan_receive;
                    $totalLoanIn += $value->loan_in;
                    $totalLoanBalance += $value->loan_balance;
                }

                // last column as letter value (e.g., D)
                $last_column = Coordinate::stringFromColumnIndex(22);
                // calculate last row + 1 (total results + header rows + column headings row + new row)
                $last_row = count($this->data) + 4;
                // set up a style array for cell formatting
                $style_text_center = [
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical'  => Alignment::VERTICAL_CENTER,
                    ],
                    'font' => [
                        'name' => 'Khmer OS Battambang',
                        'color' => array('rgb' => '000000'),
                        'size'      =>  15,
                        'bold'      =>  true,
                    ],

                ];
                $style_header = [
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical'  => Alignment::VERTICAL_CENTER,
                    ],
                    'font' => [
                        'name' => 'Khmer OS Muol Light',
                        'color' => array('rgb' => 'ffffff'),
                        'size'      =>  15,
                        'bold'      =>  true,
                        // 'background' => [
                        //     'color'=> array('rgb' => 'e1ab23'),
                        // ]
                    ],

                ];
                $color = [
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical'  => Alignment::VERTICAL_CENTER,
                    ],
                    'font' => [
                        'name' => 'Khmer OS Battambang',
                        'color' => array('rgb' => 'ffffff'),
                        'size'      =>  15,
                        'bold'      =>  true,
                        // 'background' => [
                        //     'color'=> array('rgb' => 'e1ab23'),
                        // ]
                    ],

                ];
                // at row 1, insert 2 rows
                $event->sheet->insertNewRowBefore(1,2);
                // merge cells for full-width
                $event->sheet->mergeCells(sprintf('C1:%s1', $last_column));
                $event->sheet->mergeCells("A1:B1");
                $event->sheet->mergeCells("A2:V2");
                $event->sheet->setCellValue('C1', 'បញ្ជីកម្ចី');


                $event->sheet->getRowDimension(1)->setRowHeight(100);
                $event->sheet->setCellValue(sprintf('G%d', $last_row), 'Total');
                $event->sheet->setCellValue(sprintf('H%d', $last_row), number_format($totalLoanOut));
                $event->sheet->setCellValue(sprintf('J%d', $last_row), number_format($totalService));
                $event->sheet->setCellValue(sprintf('L%d', $last_row), number_format($totalCollection));
                $event->sheet->setCellValue(sprintf('N%d', $last_row), number_format($totalSaving));
                $event->sheet->setCellValue(sprintf('P%d', $last_row), number_format($totalInterest));
                $event->sheet->setCellValue(sprintf('Q%d', $last_row), number_format($totalLoanReceived));
                $event->sheet->setCellValue(sprintf('R%d', $last_row), number_format($totalLoanIn));
                $event->sheet->setCellValue(sprintf('S%d', $last_row), number_format($totalLoanBalance));

                // align style

                $event->sheet->getStyle('A:V')->applyFromArray($style_text_center);
                $event->sheet->getStyle('A1:B1')->applyFromArray($style_text_center);
                $event->sheet->getStyle('C1:V1')->applyFromArray($style_header);
                $event->sheet->getStyle('A3:V3')->applyFromArray($color);
                $event->sheet->getDelegate()->getStyle('C1:V1')
                    ->getFill()
                    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('0c9046');
                $event->sheet->getDelegate()->getStyle('A3:V3')
                    ->getFill()
                    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                    ->getStartColor()
                 ->setARGB('0c9046');

                $event->sheet->getStyle(sprintf('G%d', $last_row), 'Total');
                $event->sheet->getStyle(sprintf('H%d', $last_row), number_format($totalLoanOut))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('J%d', $last_row), number_format($totalService))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('L%d', $last_row), number_format($totalCollection))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('N%d', $last_row), number_format($totalSaving))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('P%d', $last_row), number_format($totalInterest))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('Q%d', $last_row), number_format($totalLoanReceived))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('R%d', $last_row), number_format($totalLoanIn))->applyFromArray($style_text_center);
                $event->sheet->getStyle(sprintf('S%d', $last_row), number_format($totalLoanBalance))->applyFromArray($style_text_center);

                $drawing = new Drawing();
                $drawing->setPath(public_path('/images/logo.png'));
                $drawing->setHeight(100);
                $drawing->setOffsetX(30);
                $drawing->setOffsetY(10);
                $drawing->setCoordinates('A1');
                $drawing->setWorksheet($event->sheet->getDelegate());
            },
        ];
    }

    public function headings(): array
    {
        return [
            'ល.រ',
            'ឈ្មោះអតិថិជន',
            'ឈ្មោះមន្រ្តីឥណទាន',
            'លេខកូដកម្ចី',
            'កាលបរិច្ឆេទដាក់កម្ចី',
            'ថ្ងៃ​ចាប់ផ្តើម',
            'រំលោះ',
            'ទឹកប្រាក់កម្ចី',
            'សេវារដ្ឋបាល',
            'សេវារដ្ឋបាលសរុប',
            'សេវាហានិភ័យ',
            'សេវាហានិភ័យសរុប',
            'ប្រាក់សន្សំ',
            'ប្រាក់សន្សំសរុប',
            'ការប្រាក់',
            'ការប្រាក់សរុប',
            'ចំនួនទឹកប្រាក់កម្ចី',
            'ទឹកប្រាក់បានទទួលសរុប',
            'ទឹកប្រាក់នៅជំពាក់សរុប',
            'រយៈពេល',
            'ប្រភេទបង់ប្រាក់',
            'ស្ថានភាព',
        ];
    }
}
