<?php

namespace App\Helpers;

use Carbon\Carbon;
use App\Models\Loan;
use App\Models\User;
use App\Models\Group;
use App\Models\Client;
use App\Models\Income;
use App\Models\Expense;
use App\Models\UserBranch;
use App\Models\Accounting\Journal;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Http;
use Intervention\Image\Facades\Image;


class Helper
{

    public static function deleteFile($imagePath)
    {
        if (File::exists(public_path($imagePath))) {
            return File::delete(public_path($imagePath));
        }
    }

    public static function uploadFile($file, $path, $pathOldFile = '')
    {

        $timestamp    = str_replace([' ', ':'], '-', Carbon::now()->toDateTimeString());
        $name         = str_replace([' ', ':'], '-', $timestamp . '.' . $file->getClientOriginalName());
        $file->storeAs($path, $name);
        if ($pathOldFile != '') {
            self::deleteFile($pathOldFile);
        }
        return $path . $name;
    }

    public static function Base64Upload($stringFile, $path, $pathOldFile = '')
    {
        if ($stringFile) {
            if (!empty(explode('data:image/', $stringFile)[0])) {
                return $stringFile;
            } else {
                $timestamp = str_replace([' ', ':'], '-', Carbon::now()->toDateTimeString());
                $name   =  rand(100000, 999999) . $timestamp . '.' . explode('/', explode(':', substr($stringFile, 0, strpos($stringFile, ";")))[1])[1];
                $img    = Image::make($stringFile);
                $img->save(public_path($path) . $name);
                $img->resize(150, 150);
                if ($pathOldFile != '') {
                    self::deleteFile($pathOldFile);
                }
                return $path . $name;
            }
        } else {
            return '';
        }
    }

    public static function sendTelegramMessage($chat_id, $message)
    {
        try {
            $response = Http::post(config("somnab.telegram.api") . config("somnab.telegram.token") . "/sendMessage", [
                "chat_id"       =>  $chat_id,
                "text"          =>  $message,
                "parse_mode"    =>  "html"
            ]);
            return $response;
        } catch (\Exception $exception) {
            dd($exception);
            return $exception->getMessage();
        }
    }

    public static function codeGenerate($model, $prefixLength = 2)
    {
        $maxId = null;
        $generate = null;
        $subfix = '';
        do {
            if ($maxId == null) {
                $maxId = $model::withTrashed()->max('id');
                if ($maxId) {
                    $generate = ($maxId + 1);
                } else {
                    $generate = "1";
                }
            } else {
                $maxId++;
                $generate = ($maxId + 1);
            }
            if (strlen($generate) == 1) {
                $subfix = '000000';
                $generate = $generate . "0";
            } else {
                $subfix = '000000';
            }
        } while ($model::withTrashed()->where('code', $generate . $subfix)->exists());
        return [
            'slug' => $generate,
            'code' => $generate . $subfix
        ];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return array
     * @param $model is base modal
     * @param $modelRelated is base modal related model
     * @param $idRelated is id of modelRelated
     * @param $subfix is code plus with code generate
     */

     public static function codeGenerateRelated($model, $id, $modelRelated, $idRelated, $subfix)
     {
         $maxId = null;
         $generate = null;
         $code = '';
         $slugRelated = $modelRelated::find($idRelated);
         $oldRecode =  $model::find($id);
         if ($oldRecode) {
             $generate = $slugRelated->slug .  substr($oldRecode->slug, -2);
             if ($generate != $oldRecode->slug) {
                 $count = $model::withTrashed()->where("{$model::$relationforCode}", $idRelated)->count();
                 $code = $slugRelated->slug .  sprintf("%02d", ($count + 1)) . $subfix;
             } else {
                 $code = $oldRecode->code;
             }
         } else {
             do {
                 if ($maxId == null) {
                     $maxId = $model::withTrashed()->where("{$model::$relationforCode}", $idRelated)->count();
                     if ($maxId) {
                         $generate = $slugRelated->slug .  sprintf("%02d", ($maxId + 1));
                     } else {
                         $generate = $slugRelated->slug . sprintf("%02d", 1);
                     }
                 } else {
                     $maxId++;
                     $generate = $slugRelated->slug . sprintf("%02d", ($maxId + 1));
                 }
                 $code = $generate . $subfix;
             } while ($model::withTrashed()->where($model::$relationforCode, $idRelated)->where('code', $code)->exists());
         }
         return [
             'slug' => $generate,
             'code' => $code
         ];
     }

    public static function codeUserAuto($model, $prefix, $print, $column)
    {
        $maxId = null;
        $branch = Auth::user()->branch_id;
        $generate = null;
        do {
            if ($maxId == null) {
                $maxId = $model::where('branch_id',$branch)->where('type',1)->count();
                if ($maxId>0) {
                    $generate = 'U-'. sprintf("%0{$print}d", ($maxId + 1));
                } else {
                    $generate = 'U-'. sprintf("%0{$print}d", 1);
                }
            } else {
                $maxId++;
                $generate = 'U-'. sprintf("%0{$print}d", ($maxId + 1));
            }
        } while ($model::where($column, $generate)->exists());
        return $generate;
    }

    public static function codeClientAuto($model, $prefix, $print, $column)
    {
        $maxId = null;
        $branch = Auth::user()->branch_id;
        $generate = null;
        do {
            if ($maxId == null) {
                $maxId = $model::where('branch_id',$branch)->count();
                if ($maxId>0) {
                    $generate = sprintf("%0{$print}d", ($maxId + 1)) . '-KPT';
                } else {
                    $generate = sprintf("%0{$print}d", 1) . '-KPT';
                }
            } else {
                $maxId++;
                $generate = sprintf("%0{$print}d", ($maxId + 1)) . '-KPT';
            }
        } while ($model::where($column, $generate)->exists());
        return $generate;
    }
    public static function codeLoanAuto($model, $prefix, $print, $column)
    {
        $maxId = null;
        $branch = Auth::user()->branch_id;
        $generate = null;
        do {
            if ($maxId == null) {
                $maxId = $model::where('branch_id',$branch)->count();
                if ($maxId>0) {
                    $generate = 'L-'.sprintf("%0{$print}d", ($maxId + 1));
                } else {
                    $generate = 'L-'.sprintf("%0{$print}d", 1);
                }
            } else {
                $maxId++;
                $generate = 'L-'.sprintf("%0{$print}d", ($maxId + 1));
            }
        } while ($model::where($column, $generate)->exists());
        return $generate;
    }
    public static function codeCOAuto($model,$prefix, $print, $column)
    {
        $maxId = null;
        $branch = Auth::user()->branch_id;
        $generate = null;
        do {
            if ($maxId == null) {
                $maxId = $model::where('branch_id',$branch)->where('type',2)->count();
                if ($maxId>0) {
                    $generate = 'CO-'. sprintf("%0{$print}d", ($maxId + 1));
                } else {
                    $generate = 'CO-'. sprintf("%0{$print}d", 1);
                }
            } else {
                $maxId++;
                $generate = 'CO-'. sprintf("%0{$print}d", ($maxId + 1));
            }
        } while ($model::where($column, $generate)->exists());
        return $generate;
    }
    public static function prefix()
    {
        $branch = Auth::user()->branch_id;
        if($branch==1)
        {
            return 'PP';
        }else if($branch==2)
        {
            return 'KD';
        }
    }
    public static function codeGenerateAuto($model, $prefix, $print, $column)
    {
        $maxId = null;
        $generate = null;
        do {
            if ($maxId == null) {
                $maxId = $model::max('id');
                if ($maxId) {
                    $generate = $prefix .'-'. sprintf("%0{$print}d", ($maxId + 1));
                } else {
                    $generate = $prefix .'-'. sprintf("%0{$print}d", 1);
                }
            } else {
                $maxId++;
                $generate = $prefix .'-'. sprintf("%0{$print}d", ($maxId + 1));
            }
        } while ($model::where($column, $generate)->exists());
        return $generate;
    }

    public static function findParentId(){
        $parent_id = Journal::max('id');
        $max = $parent_id==null?1:$parent_id;
        if($parent_id==null){
            $parent_id = $max;
        }
        else{
            $parent_id =$max+1;
        }
        return $parent_id;
    }
    public static function findParentIdExpense(){
        $parent_id = Expense::max('id');
        $max = $parent_id==null?1:$parent_id;
        if($parent_id==null){
            $parent_id = $max;
        }
        else{
            $parent_id =$max+1;
        }
        return $parent_id;
    }
    public static function findParentIdIncome(){
        $parent_id = Income::max('id');
        $max = $parent_id==null?1:$parent_id;
        if($parent_id==null){
            $parent_id = $max;
        }
        else{
            $parent_id =$max+1;
        }
        return $parent_id;
    }
    public static function byBranch(){
        $log_id = Auth::id();
        $is_active_branch = Auth::user()->branch_id;
        $branches = UserBranch::select('branches.*')
            ->join('branches','branches.id','=','user_branches.branch_id')
            ->where('user_branches.user_id',$log_id)
            ->where(function($query) use ($is_active_branch){
                if($is_active_branch != -1){
                    $query->where('user_branches.branch_id',$is_active_branch);
                }
            })
            ->groupBy('user_branches.branch_id')
            ->get();
        $user_branch = [];
        foreach ($branches as $key => $value) {
                $user_branch[] = $value->id;
        }
        return $user_branch;
    }
    public static function byCurrency(){
        $user_currency = Auth::user()->currency_id;
        return $user_currency;
    }
    public static function group()
    {
        $co_id = [];
        $user = Auth::user();
        if ($user->roles[0]->id==1) { // Is admin
            $co_id = User::where('status', 1)->where('type',2)->pluck('id')->toArray();
        } else {
            $co = Group::leftJoin('users', 'users.id', '=', 'groups.user_id')
                ->where('groups.status', 1)
                ->where('users.status', 1)
                ->where('user_id', $user->id)
                ->pluck('co_id');
            if ($co->isNotEmpty()) {
                $co_id = $co->toArray();
            }
        }
        return $co_id;
    }
}
