<?php

namespace App\Http\Controllers\Admin\Accounting;

use App\Helpers\CustomDateFilter;
use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\Accounting\Journal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BalanceSheetController extends Controller
{
    public function getJournal(Request $request){
        $data = Journal::select(
            DB::raw("SUM(journals.debit-journals.credit) AS total"),
            'journals.chart_of_acc_id',
        )
        ->leftjoin('chart_of_accounts','chart_of_accounts.id','journals.chart_of_acc_id')
        ->where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            if(!$request->journal_date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(journal_date, '%Y-%m-%d')"), $request->journal_date);
            }
        })
        ->groupBy('journals.chart_of_acc_id')
        ->orderBy('chart_of_accounts.chart_code', 'ASC');
        return $data;
    }
    
    public function balanceSheet(Request $request){
        $assets =  $this->getJournal($request)
            ->whereHas('chartOfAcc',function($query){
                $query->where('chart_code','LIKE' , '1%');
            })
            ->get()->map(function($value){
                return [
                    'total' => $value->total,
                    'chart_code' => $value->chartOfAcc->chart_code??'',
                    'chart_name' => ($value->chartOfAcc->chart_name??'').' '.($value->chartOfAcc->desc??''),
                ];
            });
        $liabilities =  $this->getJournal($request)
            ->whereHas('chartOfAcc',function($query){
                $query->where('chart_code','LIKE' , '2%');
            })
            ->get()->map(function($value){
                return [
                    'total' => -$value->total,
                    'chart_code' => $value->chartOfAcc->chart_code??'',
                    'chart_name' => ($value->chartOfAcc->chart_name??'').' '.($value->chartOfAcc->desc??''),
                ];
            });
        $equities =  $this->getJournal($request)
        ->whereHas('chartOfAcc',function($query){
            $query->where('chart_code','LIKE' , '3%');
        })
        ->get()->map(function($value){
            return [
                'total' => -$value->total,
                'chart_code' => $value->chartOfAcc->chart_code??'',
                'chart_name' => ($value->chartOfAcc->chart_name??'').' '.($value->chartOfAcc->desc??''),
            ];
        });

        $incomes = $this->getJournal($request)
        ->whereHas('chartOfAcc',function($query){
            $query->where('chart_code','LIKE' , '4%');
        })
        ->get()->map(function($value){
            return [
                'total' => -$value->total,
                'chart_code' => $value->chartOfAcc->chart_code??'',
                'chart_name' => ($value->chartOfAcc->chart_name??'').' '.($value->chartOfAcc->desc??''),
            ];
        });

        $expenses = $this->getJournal($request)
        ->whereHas('chartOfAcc',function($query){
            $query->where('chart_code','LIKE' , '5%');
        })
        ->get()->map(function($value){
            return [
                'total' => $value->total,
                'chart_code' => $value->chartOfAcc->chart_code??'',
                'chart_name' => ($value->chartOfAcc->chart_name??'').' '.($value->chartOfAcc->desc??''),
            ];
        });
        $total_income  = 0;
        $total_expense = 0;
        foreach ($incomes as $income) {
            $total_income += $income["total"];
        }
        foreach ($expenses as $expense) {
            $total_expense += $expense["total"];
        }
        $return_earning = $total_income - $total_expense;

        $total_asset = 0;
        $total_liabilities = 0;
        $total_equity = 0;
        foreach ($assets as $asset) {
            $total_asset += $asset["total"];
        }
        foreach ($liabilities as $liability) {
            $total_liabilities += $liability["total"];
        }
        foreach ($equities as $equity) {
            $total_equity += $equity["total"];
        }
        $balace_sheet = $total_liabilities + $total_equity+$return_earning;

        $all = [];
        $all['return_earning']    = $return_earning;
        $all['total_asset']       = $total_asset;
        $all['total_liabilities'] = $total_liabilities;
        $all['total_equity']      = $total_equity + $return_earning;
        $all['balace_sheet']      = $balace_sheet;

        $data = array(
            'all'         => $all,
            'assets'      => $assets,
            'liabilities' => $liabilities,
            'equities'    => $equities,
        );
        return $data;
    }
}
