<?php

namespace App\Http\Controllers\Admin\Accounting;

use App\Helpers\CustomDateFilter;
use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\Accounting\JournalResource;
use App\Models\Accounting\Journal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CashFlowController extends Controller
{
    public function getCashFlow(Request $request)
    {
        $chart_of_acc_id = $request->chart_of_acc_id;
        $per_page = $request->per_page == null?25:$request->per_page;
        $data = Journal::whereHas('chartOfAcc',function($query){
            $query->whereHas('typeAccDetails',function($q){
                $q->where('id',1);
                $q->where('type_of_acc_id',10);
            });
        })
        ->where(function($query) use($request,$chart_of_acc_id){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            if(!$request->journal_date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(journal_date, '%Y-%m-%d')"), $request->journal_date);
            }
            if(!$chart_of_acc_id ==[]){
                $query->whereIn('journals.chart_of_acc_id',$chart_of_acc_id);
            }
        })
        ->where('journals.invoice_number', 'LIKE',isset($request->invoice_number)? $request->invoice_number:NULL)
        ->orderby('journals.id','ASC')
        ->paginate($per_page);
        return JournalResource::collection($data);
    }
}
