<?php

namespace App\Http\Controllers\Admin\Accounting;

use App\Http\Controllers\Controller;
use App\Models\Accounting\Asset;
use App\Models\Accounting\ChartOfAccount;
use App\Models\Accounting\TypeOfAccDetail;
use App\Models\Accounting\TypeOfAccount;

class ComponentAccountingController extends Controller
{
    
    public function getTypeAccount()
    {
        return TypeOfAccount::get()->map(function ($value) {
            return [
                'id'        => $value->id,
                'value'     => $value->id,
                'type_name' => $value->type_name,
            ];
        });
    }

    public function getTypeAccDetails($id_type_acc)
    {
        return TypeOfAccDetail::where(function($query) use($id_type_acc){
            if($id_type_acc){
                $query->where('type_of_acc_id',$id_type_acc);
            }
        })
        ->get()->map(function($value){
            return [
                'id'     => $value->id,
                'value'  => $value->id,
                'name'   => $value->name,
            ];
        });
    }
    
    public function getChartOfAccount()
    {
        return ChartOfAccount::get()->map(function ($value) {
            return [
                'id'    => $value->id,
                'value' => $value->id,
                'chart_code_name' => $value->chart_code.'-'.$value->chart_name,
            ];
        });
    }

    public function getChartOfAccCurrentAsset(){
        return ChartOfAccount::where('chart_code','LIKE','10%')->get()->map(function ($value) {
            return [
                'id'    => $value->id,
                'value' => $value->id,
                'chart_code_name' => '('.$value->chart_code.')'.' '.$value->chart_name,
            ];
        });
    }

    public function getAssets()
    {
        return Asset::get()->map(function ($value) {
            return [
                'id'    => $value->id,
                'value' => $value->id,
                'asset_name' => $value->name??'',
            ];
        });
    }

    public function getAccFixedAsset()
    {
        return ChartOfAccount::whereHas('typeAccDetails',function($query){
            $query->where('type_of_acc_id',10);
        })
        ->where('chart_code','NOT LIKE',"10%")->get()->map(function ($value) {
            return [
                'id'    => $value->id,
                'value' => $value->id,
                'chart_code_name' => '('.$value->chart_code.')'.' '.$value->chart_name??'',
            ];
        });
    }

    public function getAccExpense(){
        return ChartOfAccount::whereHas('typeAccDetails',function($query){
            $query->where('type_of_acc_id',50);
        })
        ->get()->map(function ($value) {
            return [
                'id'    => $value->id,
                'value' => $value->id,
                'chart_code_name' => '('.$value->chart_code.')'.' '.$value->chart_name??'',
            ];
        });
    }
    public function getCashBank()
    {
        return ChartOfAccount::whereIn('payment',[1,2])->get()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'chart_code_name' => $value->chart_code.'-'.$value->chart_name,
            ];
        });
    }
    public function getExpense()
    {
        return ChartOfAccount::whereIn('type_of_acc_detail_id',[7,8])->get()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'chart_code_name' => $value->chart_code.'-'.$value->chart_name,
            ];
        });
    }
    public function getIncome()
    {
        return ChartOfAccount::whereIn('type_of_acc_detail_id',[5,6])->get()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'chart_code_name' => $value->chart_code.'-'.$value->chart_name,
            ];
        });
    }
}
