<?php

namespace App\Http\Controllers\Admin\Accounting;

use App\Helpers\CustomDateFilter;
use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\Accounting\Journal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class NetProfitAndLossController extends Controller
{
    public function getJournal(Request $request){
        $data = Journal::select(
            DB::raw("SUM(journals.debit-journals.credit) AS total"),
            'journals.chart_of_acc_id',
        )
        ->leftjoin('chart_of_accounts','chart_of_accounts.id','journals.chart_of_acc_id')
        ->where(function($query) use($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            if(!$request->journal_date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(journal_date, '%Y-%m-%d')"), $request->journal_date);
            }
        })
        ->groupBy('journals.chart_of_acc_id')
        ->orderBy('chart_of_accounts.chart_code', 'ASC');
        return $data;
    }

    public function getProfitLoss(Request $request){
        $incomes = $this->getJournal($request)
            ->whereHas('chartOfAcc',function($query){
                $query->where('chart_code','LIKE' , '4%');
                $query->where('chart_code','!=' ,'40001');
            })
            ->get()->map(function($value){
                return [
                    'total' => -$value->total,
                    'chart_code' => $value->chartOfAcc->chart_code??'',
                    'chart_name' => ($value->chartOfAcc->chart_name??'').' '.($value->chartOfAcc->desc??''),
                ];
            });

        $generalExep = $this->getJournal($request)
            ->whereHas('chartOfAcc',function($query){
                $query->where('chart_code','LIKE' ,'5%');
                $query->where('chart_code','!=' ,'50001');
            })
            ->get()->map(function($value){
                return [
                    'total' => $value->total,
                    'chart_code' => $value->chartOfAcc->chart_code??'',
                    'chart_name' => ($value->chartOfAcc->chart_name??'').' '.($value->chartOfAcc->desc??''),
                ];
            });

        $net_profit = 0;
        $total_revenue = 0;
        $total_income  = 0;
        $total_expense_cost = 0;
        $total_glexpense = 0;

        foreach ($incomes as  $income) {
            $total_income += $income["total"];
        }
        foreach ($generalExep as  $expense) {
            $total_glexpense += $expense["total"];
        }
        //Net Income
        $net_profit = $total_income - $total_expense_cost - $total_glexpense;
        $data = [
            'incomes'         => $incomes,
            'total_income'    => $total_income,
            'glexspenses'     => $generalExep,
            'total_glexpense' => $total_glexpense,
            'net_profit'      => $net_profit,
            'total_cost_ogs'  => $total_expense_cost,
        ];
        return $data;

    }
}
