<?php

namespace App\Http\Controllers\Admin\Accounting;

use App\Http\Controllers\Controller;
use App\Http\Resources\Accounting\TypeOfAccDetailResource;
use App\Http\Resources\Accounting\TypeOfAccountResource;
use App\Models\Accounting\ChartOfAccount;
use App\Models\Accounting\TypeOfAccDetail;
use App\Models\Accounting\TypeOfAccount;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class TypeOfAccountController extends Controller
{
    public function index(Request $request)
    {
        $per_page = $request->per_page == null ? 25 : $request->per_page;
        $data = TypeOfAccount::search($request->search_text)
            ->orderby('id', 'ASC')
            ->paginate($per_page);
        return TypeOfAccountResource::collection($data);
    }

    public function create(Request $request)
    {
        $typeAcc = TypeOfAccDetail::find($request->id);
        if ($typeAcc) {
            $res = [
                'status'  => 1,
                'message' => 'Get TypeOfAccDetail success',
                'data'    => new TypeOfAccDetailResource($typeAcc),
            ];
        } else {
            $res = [
                'status'  => 0,
                'message' => 'Get TypeOfAccDetail not found',
                'data'    => [],
            ];
        }
        return response()->json($res, 200);
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'type_of_acc_id' => 'required',
            'name' => 'required',
        ]);
        DB::beginTransaction();
        try {
            $typ_acc = TypeOfAccDetail::updateOrCreate(
                ['id' => $request->id], 
                [
                    'type_of_acc_id' => $request->type_of_acc_id,
                    'name'       => $request->name,
                    'remark'     => $request->remark,
                    'created_by' => Auth::user()->id,
                ]
            );
            DB::commit();
            $res = [
                'status'  => 1,
                'message' => $typ_acc->wasRecentlyCreated ? 'Create TypeOfAccDetail success' : 'Update TypeOfAccDetail success',
                'data'    => new TypeOfAccDetailResource($typ_acc),
            ];
        } catch (\Exception $e) {
            DB::rollback();
            $res = [
                'status'  => 0,
                'message' => 'Create TypeOfAccDetail not success',
                'data'    => $e->getMessage(),
            ];
        }
        return response()->json($res, 200);
    }

    public function destroy($id)
    {
        DB::beginTransaction();
        try {
            $typeAccDetails = TypeOfAccDetail::find($id);
            if($typeAccDetails){
                $chartAcc = ChartOfAccount::where('type_of_acc_detail_id',$id)->count();
                if($chartAcc>0)
                {
                    $res = [
                        'status'  => 0,
                        'message' => 'Can not Delete!',
                        'data'    => $typeAccDetails,
                    ];
                }
                else{
                    $typeAccDetails->delete();
                    DB::commit();
                    $res = [
                        'status'  => 1,
                        'message' => 'Deleted success',
                        'data'    => $typeAccDetails,
                    ];
                }
            }
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Deleted not success',
                'data'    => $e->getMessage(),
            ];
        }
        return response()->json($res, 200);
    }
}
