<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Resources\BranchResource;
use App\Models\Branch;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BranchController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Branch List', ['only' => ['index']]);
        $this->middleware('permission:Branch Create', ['only' => ['store']]);
        $this->middleware('permission:Branch Edit', ['only' => ['store']]);
        $this->middleware('permission:Branch Delete', ['only' => ['destroy']]);
    }
    public function index(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Branch::orderBy('id','DESC')->paginate($per_page);
        return BranchResource::collection($data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $branch = Branch::find($request->id);
        if($branch){
            $res = [
                'status' => 1,
                'message'=> 'Create branch success',
                'data'   => $branch
            ];
        }else{
            $res = [
                'status'  => 0,
                'message' => 'Create branch not found',
                'data'    => []
            ];
        }
        return response()->json($res,200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name_en' => 'nullable|required',
            'name_km' => 'nullable|required'
        ]);
        try{
            DB::beginTransaction();
            $com = Branch::updateOrCreate(['id' => $this->getBranchRequest($request)['id']],$this->getBranchRequest($request));

            DB::commit();
            $res = [
                'status' => 1,
                'message'=> $com->wasRecentlyCreated?'Create Branch success':'Update Branch success',
                'data'   => $com
            ];
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Create Branch not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        DB::beginTransaction();
        try {

            $branch = Branch::find($id);
            $branch->delete();
            $res = [
                'status' => 1,
                'message'=> 'Deleted success',
                'data'   => $branch
            ];
            DB::commit();
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Deleted not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);
    }
    public function getBranchRequest($request)
    {
        $data = [
            'id'        => $request->id,
            'name_km' => $request->name_km,
            'name_en' => $request->name_en,
            'phone' => $request->phone,
            'address' => $request->address,
            'province_id' => $request->province_id,
            'district_id' => $request->district_id,
            'commune_id' => $request->commune_id,
            'village_id' => $request->village_id
        ];
        return $data;
    }
}
