<?php

namespace App\Http\Controllers\Admin;

use App\Models\Category;
use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CategoryController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Category List', ['only' => ['index']]);
        $this->middleware('permission:Category Create', ['only' => ['store']]);
        $this->middleware('permission:Category Edit', ['only' => ['store']]);
        $this->middleware('permission:Category Delete', ['only' => ['destroy']]);
    }
    public function index(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Category::where(function($query) use ($request){
            if(!$request->search_text ==''){
                $query->where('title', 'LIKE', '%'.$request->search_text.'%');
            }
        })
        ->orderBy('id','DESC')
        ->paginate($per_page);
        return $data;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $cat = Category::find($request->id);

        if($cat){
            $res = [
                'status' => 1,
                'message'=> 'Create category success',
                'data'   => $cat
            ];
        }else{
            $res = [
                'status'  => 0,
                'message' => 'Create category not found',
                'data'    => []
            ];
        }
        return response()->json($res,200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'nullable|required'
        ]);
        try{
            DB::beginTransaction();
            $com = Category::updateOrCreate(['id' => $this->getCategoryRequest($request)['id']],$this->getCategoryRequest($request));

            DB::commit();
            $res = [
                'status' => 1,
                'message'=> $com->wasRecentlyCreated?'Create Category success':'Update Category success',
                'data'   => $com
            ];
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Create Category not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function show(Category $category)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function edit(Category $category)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Category $category)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        DB::beginTransaction();
        try {

            $cat = Category::find($id);
            $cat->delete();
            $res = [
                'status' => 1,
                'message'=> 'Deleted success',
                'data'   => $cat
            ];
            DB::commit();
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Deleted not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);
    }
    public function getCategoryRequest($request)
    {
        $data = [
            'id'        => $request->id,
            'title' => $request->title,
            'purpose' => $request->purpose
        ];
        return $data;
    }
}
