<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Models\Client;
use App\Http\Controllers\Controller;
use App\Http\Resources\ClientResource;
use App\Http\Resources\GuarantorResource;
use App\Models\Guarantor;
use App\Models\Village;
use Exception;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;

class ClientController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Client List', ['only' => ['index']]);
        $this->middleware('permission:Client Create', ['only' => ['store','create']]);
        $this->middleware('permission:Client Edit', ['only' => ['store','create']]);
        $this->middleware('permission:Client Delete', ['only' => ['destroy']]);
    }
    public function index(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Client::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            if(!$request->search_text ==''){
                $query->where('name', 'LIKE', '%'.$request->search_text.'%');
                $query->Orwhere('code', 'LIKE', '%'.$request->search_text.'%');
                $query->Orwhere('id_card', 'LIKE', '%'.$request->search_text.'%');
                $query->Orwhere('phone', 'LIKE', '%'.$request->search_text.'%');
            }
        })
        ->orderBy('id','DESC')
        ->paginate($per_page);
        return ClientResource::collection($data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $client = Client::find($request->id);
        $profile = Guarantor::where('client_id',$request->id)->where('type',1)->first();
        $one = Guarantor::where('client_id',$request->id)->where('type',2)->first();
        $two = Guarantor::where('client_id',$request->id)->where('type',3)->first();

        if($client){
            $res = [
                'status' => 1,
                'message'=> 'Create client success',
                'client'   => new ClientResource($client),
                'profile'   => $profile?(new GuarantorResource($profile)):null,
                'one'   =>  $one?(new GuarantorResource($one)):null,
                'two'   =>  $two?(new GuarantorResource($two)):null
            ];
        }else{
            $res = [
                'status'  => 0,
                'message' => 'Create client not found',
                'data'    => []
            ];
        }
        return response()->json($res,200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // try{
        //     DB::beginTransaction();
            $home = $request->home;
            $profile = $request->profile;
            $one = $request->one;
            $two = $request->two;
            $branch_id = Auth::user()->branch_id;
            $com = Client::updateOrCreate(['id' => $this->getClientRequest($home)['id']],$this->getClientRequest($home));


            if($profile['name']==null)
            {
                    $pro = Guarantor::where('client_id',$home['id'])->where('type',1)->first();
                    if($pro)
                    {
                        Guarantor::where('client_id',$home['id'])->where('type',1)->delete();
                    }
            }
            else
            {
                    $village = Village::where('id',$profile['village_id'])->first();
                    $profile_photo = Guarantor::find($profile['id']);
                    $image = Helper::Base64Upload($profile['photo'], 'uploads/guarantors/',  $profile_photo->photo??'');
                    Guarantor::updateOrCreate(
                        [
                            'id'        => $profile['id'],
                            'type'      => 1
                        ],[
                            'name' => $profile['name'] ?? '',
                            'name_en' => $profile['name_en'] ?? '',
                            'client_id' => $com->id,
                            'branch_id' => $branch_id,
                            'phone' => $profile['phone'],
                            'gender' => $profile['gender'],
                            'type_document' => $profile['type_document'],
                            'id_card' => $profile['id_card'],
                            'date_of_birth' => $profile['date_of_birth'],
                            'place_of_birth' => $profile['place_of_birth'],
                            'create_card_date' => $profile['create_card_date'],
                            'expired_card_date' => $profile['expired_card_date'],
                            'institution' => $profile['institution'],
                            'position' => $profile['position'],
                            'work_place' => $profile['work_place'],
                            'province_id' => $profile['province_id'],
                            'district_id' => $profile['district_id'],
                            'commune_id' => $profile['commune_id'],
                            'village_id' => $profile['village_id'],
                            'issued_by' => $profile['issued_by'],
                            'relationship' => $profile['relationship'],
                            'income' => $profile['income'],
                            'expense' => $profile['expense'],
                            'balance' => $profile['balance'],
                            'photo'     => $image??'uploads/guarantors/default.png',
                            'status' => $profile['status']??1,
                            'created_by' => Auth::user()->id,
                            'village_kh' => $village?$village->name_km:null
                        ]);
            }
            if($one['name']==null)
            {
                    $o = Guarantor::where('client_id',$home['id'])->where('type',2)->first();
                    if($o)
                    {
                        Guarantor::where('client_id',$home['id'])->where('type',2)->delete();
                    }
            }
            else
            {
                    $village = Village::where('id',$one['village_id'])->first();
                    $one_photo = Guarantor::find($one['id']);
                    $image = Helper::Base64Upload($one['photo'], 'uploads/guarantors/',  $one_photo->photo??'');
                    Guarantor::updateOrCreate(
                        [
                            'id'        => $one['id'],
                            'type'      => 2,
                        ],[
                            'name' => $one['name'] ?? '',
                            'name_en' => $one['name_en'] ?? '',
                            'client_id' => $com->id,
                            'branch_id' => $branch_id,
                            'phone' => $one['phone'],
                            'gender' => $one['gender'],
                            'type_document' => $one['type_document'],
                            'id_card' => $one['id_card'],
                            'date_of_birth' => $one['date_of_birth'],
                            'place_of_birth' => $one['place_of_birth'],
                            'create_card_date' => $one['create_card_date'],
                            'expired_card_date' => $one['expired_card_date'],
                            'institution' => $one['institution'],
                            'position' => $one['position'],
                            'work_place' => $one['work_place'],
                            'province_id' => $one['province_id'],
                            'district_id' => $one['district_id'],
                            'commune_id' => $one['commune_id'],
                            'village_id' => $one['village_id'],
                            'issued_by' => $one['issued_by'],
                            'relationship' => $one['relationship'],
                            'income' => $profile['income'],
                            'expense' => $profile['expense'],
                            'balance' => $profile['balance'],
                            'photo'     => $image??'uploads/guarantors/default.png',
                            'status' => $one['status']??1,
                            'created_by' => Auth::user()->id,
                            'village_kh' => $village?$village->name_km:null
                        ]);
            }
            if($two['name']==null)
            {
                    $t = Guarantor::where('client_id',$home['id'])->where('type',3)->first();
                    if($t)
                    {
                        Guarantor::where('client_id',$home['id'])->where('type',3)->delete();
                    }
            }
            else
            {
                    $village = Village::where('id',$two['village_id'])->first();
                    $two_photo = Guarantor::find($two['id']);
                    $image = Helper::Base64Upload($two['photo'], 'uploads/guarantors/',  $two_photo->photo??'');
                    Guarantor::updateOrCreate(
                        [
                            'id'        => $two['id'],
                            'type'      => 3
                        ],[
                            'name' => $two['name'] ?? '',
                            'name_en' => $two['name_en'] ?? '',
                            'client_id' => $com->id,
                            'branch_id' => $branch_id,
                            'phone' => $two['phone'],
                            'gender' => $two['gender'],
                            'type_document' => $two['type_document'],
                            'id_card' => $two['id_card'],
                            'date_of_birth' => $two['date_of_birth'],
                            'place_of_birth' => $two['place_of_birth'],
                            'create_card_date' => $two['create_card_date'],
                            'expired_card_date' => $two['expired_card_date'],
                            'institution' => $two['institution'],
                            'position' => $two['position'],
                            'work_place' => $two['work_place'],
                            'province_id' => $two['province_id'],
                            'district_id' => $two['district_id'],
                            'commune_id' => $two['commune_id'],
                            'village_id' => $two['village_id'],
                            'issued_by' => $two['issued_by'],
                            'relationship' => $two['relationship'],
                            'income' => $profile['income'],
                            'expense' => $profile['expense'],
                            'balance' => $profile['balance'],
                            'photo'     => $image??'uploads/guarantors/default.png',
                            'status' => $two['status']??1,
                            'created_by' => Auth::user()->id,
                            'village_kh' => $village?$village->name_km:null
                        ]);
            }

            $res = [
                'status' => 1,
                'message'=> $com->wasRecentlyCreated?'Create Client success':'Update Client success',
                'data'   => new ClientResource($com),
            ];
        //     DB::commit();
        // }catch(Exception $e){
        //     DB::rollBack();
        //     $res = [
        //         'status'  => 0,
        //         'message' => 'Create Client not success',
        //         // 'data'    => $e->getMessage(),
        //     ];
        // }
        return response()->json($res,200);
    }

    public function show($id)
    {
        $data = Client::find($id)->first();
        return $data;
    }

    public function destroy($id)
    {
        DB::beginTransaction();
        try {
            $client = Client::find($id);
            if($client->clientHasLoan->count()>0){
                $res = [
                    'status'  => 0,
                    'message' => 'មិនអាចលុបបានទេ ពីព្រោះលោកអ្នកបានធ្វើប្រត្តិបត្តិការរួចហើយ',
                    'data'    => ''
                ];
            } else{
                $client->delete();
                $res = [
                    'status' => 1,
                    'message'=> 'Deleted success',
                    'data'   => $client
                ];
            }
            DB::commit();
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Deleted not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);
    }

    public function getClientRequest($request)
    {
        // dd($request->name);
        $branch_id = Auth::user()->branch_id;
        $village = Village::where('id',$request['village_id'])->first();
        $client = Client::find($request['id']);
        $image = Helper::Base64Upload($request['photo'], 'uploads/clients/',  $client->photo??'');
        // dd($request['name']);
        $data = [
            'id'        => $request['id'],
            'code'      => $request['code']??Helper::codeClientAuto(Client::class, Helper::prefix(),6, 'code'),
            'name' => $request['name'] ?? $request['name'],
            'name_en' => $request['name_en'] ?? $request['name_en'],
            'branch_id' => $branch_id,
            'phone' => $request['phone'],
            'gender' => $request['gender'],
            'type_document' => $request['type_document'],
            'id_card' => $request['id_card'],
            'date_of_birth' => $request['date_of_birth'],
            'place_of_birth' => $request['place_of_birth'],
            'create_card_date' => $request['create_card_date'],
            'expired_card_date' => $request['expired_card_date'],
            'institution' => $request['institution'],
            'position' => $request['position'],
            'work_place' => $request['work_place'],
            'province_id' => $request['province_id'],
            'district_id' => $request['district_id'],
            'commune_id' => $request['commune_id'],
            'village_id' => $request['village_id'],
            'issued_by' => $request['issued_by'],
            'relationship' => $request['relationship'],
            'income' => $request['income'],
            'expense' => $request['expense'],
            'balance' => $request['balance'],
            'photo'     => $image??'uploads/client/default.png',
            'status' => $request['status']??1,
            'created_by' => Auth::user()->id,
            'village_kh' => $village?$village->name_km:null
        ];
        return $data;
    }
}
