<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\CustomDateFilter;
use App\Helpers\Helper;
use App\Helpers\LogActivity;
use App\Http\Controllers\Controller;
use App\Http\Resources\CollectedResource;
use App\Models\Accounting\ChartOfAccount;
use App\Models\Accounting\Journal;
use App\Models\AccReceivableDetails;
use App\Models\AccReceivables;
use App\Models\BackPayment;
use App\Models\Loan;
use App\Models\PaymentMethod;
use App\Models\User;
use App\Models\Client;
use App\Models\Reschedule;
use App\Models\Saving;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ClientPaymentController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Daily Payment|Co Received Report|Cashier Received Report', ['only' => ['DailyPayment']]);
        $this->middleware('permission:Closing Report', ['only' => ['index']]);
        $this->middleware('permission:Submit Closing Report', ['only' => ['ClosingReport']]);
        $this->middleware('permission:Repay', ['only' => ['store']]);
        $this->middleware('permission:Repay Edit', ['only' => ['update']]);
        $this->middleware('permission:Repay Delete', ['only' => ['destroy']]);
        $this->middleware('permission:Pay Of', ['only' => ['SubmitPayAll']]);
    }
    public function DailyPayment(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = AccReceivableDetails::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            $query->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), $request->date ?? CustomDateFilter::thisDay());
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        });
        // ->paginate($per_page);
        // return CollectedResource::collection($data);

        if($request->per_page=="ALL" || $request->pagin == 'true'){
            return CollectedResource::collection($data->get());
        } else {
            return CollectedResource::collection($data->paginate($per_page));
        }

    }

    public function index(Request $request)
    {

        $Disbursed = Loan::select(
                DB::raw('SUM(loan_out) AS LoanDisbursed'),
                DB::raw('SUM(total_service) AS totalService'),
                DB::raw('SUM(total_collection) AS totalCollection'),
                DB::raw('SUM(total_saving) AS SavingTotal')
            )
            ->where(function($query) use ($request){
                $query->where('loan_status_id',2);
                $query->whereIn('branch_id',Helper::byBranch());
                $query->where('currency_id',Helper::byCurrency());
                // $query->whereIn('co_id',Helper::group());
                if(!$request->client_id ==[]){
                    $query->whereIn('client_id',$request->client_id);
                }
                if($request->today == null && $request->date==[])
                {
                    $query->where('closing_date',null);
                }
                if($request->today == null){
                    $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), $request->date ?? CustomDateFilter::thisDay());
                }
                if($request->today != null){
                    $query->where('closing_date',null);
                    $query->where(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"),$request->today);
                }
                if(!$request->co_id ==[])
                {
                    $query->whereIn('co_id',$request->co_id);
                }
            })
            ->first();


        $Saving = Saving::select(
            DB::raw('SUM(savings.amount) AS totalSaving'),
            )
            ->where(function($query) use ($request){
                $query->where('status_pay',2);
                $query->where('status',4);
                $query->whereIn('branch_id',Helper::byBranch());
                $query->where('currency_id',Helper::byCurrency());
                $query->whereIn('co_id',Helper::group());
                if($request->today == null){
                    $query->whereBetween(DB::raw("DATE_FORMAT(date_approved, '%Y-%m-%d')"), $request->date ?? CustomDateFilter::thisDay());
                }
                if($request->today == null && $request->date==[])
                {
                    $query->where('closing_date',null);
                }
                if($request->today != null){
                    $query->where('closing_date',null);
                    $query->where(DB::raw("DATE_FORMAT(date_approved, '%Y-%m-%d')"),$request->today);
                }
                if(!$request->client_id ==[]){
                    $query->whereIn('client_id',$request->client_id);
                }
                if(!$request->co_id ==[])
                {
                    $query->whereIn('co_id',$request->co_id);
                }
            })->first();
        $SavingToClient = Saving::select(
            DB::raw('SUM(savings.amount) AS totalSavingClient'),
            )
            ->where(function($query) use ($request){
                $query->where('status_pay',1);
                $query->where('status',3);
                $query->whereIn('branch_id',Helper::byBranch());
                $query->where('currency_id',Helper::byCurrency());
                $query->whereIn('co_id',Helper::group());

                if($request->today == null){
                    $query->whereBetween(DB::raw("DATE_FORMAT(date_approved, '%Y-%m-%d')"), $request->date ?? CustomDateFilter::thisDay());
                }
                if($request->today == null && $request->date==[])
                {
                    $query->where('closing_date',null);
                }
                if($request->today != null){
                    $query->where('closing_date',null);
                    $query->where(DB::raw("DATE_FORMAT(date_approved, '%Y-%m-%d')"),$request->today);
                }
                if(!$request->client_id ==[]){
                    $query->whereIn('client_id',$request->client_id);
                }
                if(!$request->co_id ==[])
                {
                    $query->whereIn('co_id',$request->co_id);
                }
            })->first();
        $AccDetail = AccReceivableDetails::select(
                    DB::raw('SUM(paid_principal) as paidPrincipal'),
                    DB::raw('SUM(paid_interest) as paidInterest'),
                    DB::raw('SUM(paid_risk) as paidRisk'),
                    DB::raw('SUM(paid_maintenance) as paidMaintenance'),
                    DB::raw('SUM(paid_penalty) as paidPenalty')
                )
                ->where(function($query) use ($request){
                    $query->where('status',2);
                    $query->whereIn('branch_id',Helper::byBranch());
                    $query->where('currency_id',Helper::byCurrency());
                    $query->whereIn('co_id',Helper::group());

                    if($request->today == null){
                        $query->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), $request->date ?? CustomDateFilter::thisDay());
                    }
                    if($request->today == null && $request->date==[])
                    {
                        $query->where('closing_date',null);
                    }
                    if($request->today != null){
                        $query->where('closing_date',null);
                        $query->where(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"),$request->today);
                    }
                    if(!$request->client_id ==[]){
                        $query->whereIn('client_id',$request->client_id);
                    }
                    if(!$request->co_id ==[])
                    {
                        $query->whereIn('co_id',$request->co_id);
                    }
                })
                ->first();
        $principalAdd = Reschedule::select(
                // DB::raw('SUM(amount) as principalAdd'),
                DB::raw('SUM(reschedule_total) as reschedule_total'),
                DB::raw('SUM(service_total) as service_total'),
            )
            ->where(function($query) use ($request){
                $query->whereIn('branch_id',Helper::byBranch());
                $query->where('currency_id',Helper::byCurrency());
                $query->whereIn('co_id',Helper::group());
                $query->where('status',3);
                if($request->today == null){
                    $query->whereBetween(DB::raw("DATE_FORMAT(date, '%Y-%m-%d')"), $request->date ?? CustomDateFilter::thisDay());
                }
                if($request->today == null && $request->date==[])
                {
                    $query->where('closing_date',null);
                }
                if($request->today != null){
                    $query->where('closing_date',null);
                    $query->where(DB::raw("DATE_FORMAT(date, '%Y-%m-%d')"),$request->today);
                }
                if(!$request->client_id ==[]){
                    $query->whereIn('client_id',$request->client_id);
                }
                if(!$request->co_id ==[])
                {
                    $query->whereIn('co_id',$request->co_id);
                }
            })->first();
        $totalRepayClient = $AccDetail->paidPrincipal+$AccDetail->paidInterest+$AccDetail->paidRisk
                        +$AccDetail->paidMaintenance+$AccDetail->paidPenalty+$AccDetail->penaltyInterest;
        $TotalReceived = $totalRepayClient+$Disbursed->totalCollection+$Disbursed->totalService+$Disbursed->SavingTotal+$Saving->totalSaving;

        return array(
            'LoanDisbursed'=>$Disbursed->LoanDisbursed?$Disbursed->LoanDisbursed:0,
            'totalService'=>($Disbursed->totalService?$Disbursed->totalService:0),
            'totalCollection'=>$Disbursed->totalCollection?$Disbursed->totalCollection:0,
            'SavingTotal'=>$Disbursed->SavingTotal?$Disbursed->SavingTotal:0,
            'paidPrincipal'=>$AccDetail->paidPrincipal?$AccDetail->paidPrincipal:0,
            'paidInterest'=>($AccDetail->paidInterest?$AccDetail->paidInterest:0),
            'paidRisk'=>$AccDetail->paidRisk?$AccDetail->paidRisk:0,
            'paidMaintenance'=>$AccDetail->paidMaintenance?$AccDetail->paidMaintenance:0,
            'paidPenalty'=>$AccDetail->paidPenalty?$AccDetail->paidPenalty:0,
            'TotalReceived'=>$TotalReceived?$TotalReceived:0,
            'totalRepayClient'=>$totalRepayClient?$totalRepayClient:0,
            'principalAdd'=>$principalAdd->principalAdd?$principalAdd->principalAdd:0,
            'rescheduleTotal'=>$principalAdd->reschedule_total?$principalAdd->reschedule_total:0,
            'totalSavingClient'=>$SavingToClient->totalSavingClient,
            'totalSaving'=>$Saving->totalSaving
          );
    }
    public function ClosingReport(Request $request)
    {
        $today = (empty($request->params['today'])?date('Y-m-d'):date('Y-m-d',strtotime($request->params['today'])));
        $LoanDisbursed = $request->dataPayments['LoanDisbursed'];
        $SavingTotal = $request->dataPayments['SavingTotal'];
        $paidPrincipal = $request->dataPayments['paidPrincipal'];
        $principalAdd = $request->dataPayments['principalAdd'];
        $rescheduleTotal = $request->dataPayments['rescheduleTotal'];
        $paidInterest = $request->dataPayments['paidInterest'] ;
        $paidRisk = $request->dataPayments['paidRisk'];
        $paidMaintenance = $request->dataPayments['paidMaintenance'];
        $paidPenalty = $request->dataPayments['paidPenalty'];
        $totalService = $request->dataPayments['totalService'];
        $totalCollection = $request->dataPayments['totalCollection'];
        $totalSaving = $request->dataPayments['totalSaving'];
        $totalSavingClient = $request->dataPayments['totalSavingClient'];
        $client_id = $request->client_id;
        $co_id = $request->co_id;
        $date = $request->params['today'].' '.date('H:i:s');
        try{
            DB::beginTransaction();
            // dd(Auth::user()->currency_id);
            Loan::select(
                    DB::raw('SUM(loan_out) AS LoanDisbursed'),
                    DB::raw('SUM(total_service) AS totalService'),
                    DB::raw('SUM(total_collection) AS totalCollection'),
                    DB::raw('SUM(total_saving) AS SavingTotal')
                )
                ->where(function($query) use ($today,$client_id,$co_id){
                    $query->where('closing_date',null);
                    $query->where('loan_status_id',2);
                    $query->whereIn('branch_id',Helper::byBranch());
                    $query->where('currency_id',Helper::byCurrency());
                    $query->whereIn('co_id',Helper::group());
                    $query->where(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), $today);
                    if(!$client_id ==[]){
                        $query->whereIn('client_id',$client_id);
                    }
                    if(!$co_id ==[])
                    {
                        $query->whereIn('co_id',$co_id);
                    }
                })
                ->update([
                    'closing_date' => empty($request->params['today'])?date('Y-m-d H:i:s'):date('Y-m-d H:i:s',strtotime($date)),
                    'closing_by' => Auth::user()->id,
                ]);
                Reschedule::select(
                    // DB::raw('SUM(amount) as principalAdd'),
                    DB::raw('SUM(reschedule_total) as reschedule_total'),
                    DB::raw('SUM(service_total) as service_total')
                )
               ->where(function($query) use ($today,$client_id,$co_id){
                    $query->where('closing_date',null);
                    $query->where('status',3);
                    $query->whereIn('branch_id',Helper::byBranch());
                    $query->where('currency_id',Helper::byCurrency());
                    $query->whereIn('co_id',Helper::group());
                    $query->where(DB::raw("DATE_FORMAT(date, '%Y-%m-%d')"), $today);
                    if(!$client_id ==[]){
                        $query->whereIn('client_id',$client_id);
                    }
                    if(!$co_id ==[])
                    {
                        $query->whereIn('co_id',$co_id);
                    }
                })
                ->update([
                    'closing_date' => empty($request->params['today'])?date('Y-m-d H:i:s'):date('Y-m-d H:i:s',strtotime($date)),
                    'closing_by' => Auth::user()->id,
                ]);
                Saving::where(function($query) use ($today,$client_id,$co_id){
                    $query->where('closing_date',null);
                    $query->whereIn('branch_id',Helper::byBranch());
                    $query->where('currency_id',Helper::byCurrency());
                    $query->whereIn('co_id',Helper::group());
                    $query->where(DB::raw("DATE_FORMAT(date_approved, '%Y-%m-%d')"), $today);
                    if(!$client_id ==[]){
                        $query->whereIn('client_id',$client_id);
                    }
                    if(!$co_id ==[])
                    {
                        $query->whereIn('co_id',$co_id);
                    }
                })
                ->update([
                    'closing_date' => empty($request->params['today'])?date('Y-m-d H:i:s'):date('Y-m-d H:i:s',strtotime($date)),
                    'closing_by' => Auth::user()->id,
                ]);

            AccReceivableDetails::select(
                        DB::raw('SUM(paid_principal) as paidPrincipal'),
                        DB::raw('SUM(paid_interest) as paidInterest'),
                        DB::raw('SUM(paid_risk) as paidRisk'),
                        DB::raw('SUM(paid_maintenance) as paidMaintenance'),
                        DB::raw('SUM(paid_penalty) as paidPenalty')
                    )
                    ->where(function($query) use ($today,$client_id,$co_id){
                        $query->where('closing_date',null);
                        $query->where('status',2);
                        $query->whereIn('branch_id',Helper::byBranch());
                        $query->where('currency_id',Helper::byCurrency());
                        $query->whereIn('co_id',Helper::group());
                        $query->where(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), $today);
                        if(!$client_id ==[]){
                            $query->whereIn('client_id',$client_id);
                        }
                        if(!$co_id ==[])
                        {
                            $query->whereIn('co_id',$co_id);
                        }
                    })
                    ->update([
                        'closing_date' => empty($request->params['today'])?date('Y-m-d H:i:s'):date('Y-m-d H:i:s',strtotime($date)),
                        'closing_by' => Auth::user()->id,
                    ]);
                    $loan = ChartOfAccount::where('chart_code','50001')->first();
                    $principal = ChartOfAccount::where('chart_code','40001')->first();
                    $prinAdd = ChartOfAccount::where('chart_code','50018')->first();
                    $reschedule = ChartOfAccount::where('chart_code','40008')->first();
                    $interest = ChartOfAccount::where('chart_code','40002')->first();
                    $risk = ChartOfAccount::where('chart_code','40003')->first();
                    $hanipei = ChartOfAccount::where('chart_code','40011')->first();
                    $service = ChartOfAccount::where('chart_code','40004')->first();
                    $maintenance = ChartOfAccount::where('chart_code','40005')->first();
                    $penalty = ChartOfAccount::where('chart_code','40006')->first();
                    $cash = ChartOfAccount::where('chart_code','10001')->first();
                    $accRe = ChartOfAccount::where('chart_code','10006')->first();
                    $Revenues = ChartOfAccount::where('chart_code','20002')->first();
                    $saving_client = ChartOfAccount::where('chart_code','20006')->first();
                    $saving = ChartOfAccount::where('chart_code','40012')->first();
                    $payment_method = PaymentMethod::find(1);
                    if($LoanDisbursed>0)
                    {
                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $loan->id,
                            'credit'        => 0,
                            'debit'        => $LoanDisbursed,
                            'desc'        => 'ចំណាយទឹកប្រាក់កម្ចីផ្ដល់អោយអតិថិជន បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => $LoanDisbursed,
                            'debit'        => 0,
                            'desc'        => 'ចំណាយទឹកប្រាក់កម្ចីផ្ដល់អោយអតិថិជន បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $accRe->id,
                            'credit'        => 0,
                            'debit'        => $LoanDisbursed,
                            'desc'        => 'ចំណាយទឹកប្រាក់កម្ចីផ្ដល់អោយអតិថិជន បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $Revenues->id,
                            'credit'        => $LoanDisbursed,
                            'debit'        => 0,
                            'desc'        => 'ប្រាក់អតិថិជនជំពាក់ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                    }
                    if($SavingTotal>0)
                    {
                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $saving_client->id,
                            'credit'        => $SavingTotal,
                            'debit'        => 0,
                            'desc'        => 'បំណុលពីអតិថិជនដាក់ប្រាក់សន្សំ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => 0,
                            'debit'        => $SavingTotal,
                            'desc'        => 'បំណុលពីអតិថិជនដាក់ប្រាក់សន្សំ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                    }
                    if($principalAdd>0)
                    {
                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $prinAdd->id,
                            'credit'        => 0,
                            'debit'        => $principalAdd,
                            'desc'        => 'Principal Expense closing from '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => $principalAdd,
                            'debit'        => 0,
                            'desc'        => 'Principal closing from '.$user->name.'',
                            'status'        => 1
                        ]);

                    }
                    if($paidPrincipal>0)
                    {

                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $principal->id,
                            'credit'        => $paidPrincipal,
                            'debit'        => 0,
                            'desc'        => 'ចំណូលបានមកពីប្រាក់ដើម បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => 0,
                            'debit'        => $paidPrincipal,
                            'desc'        => 'ចំណូលបានមកពីប្រាក់ដើម បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $accRe->id,
                            'credit'        => $paidPrincipal,
                            'debit'        => 0,
                            'desc'        => 'ប្រាក់ដើមប្រមូលបាន បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $Revenues->id,
                            'credit'        => 0,
                            'debit'        => $paidPrincipal,
                            'desc'        => 'ប្រាក់ដើមប្រមូលបាន បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                    }
                    if($paidInterest>0)
                    {
                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $interest->id,
                            'credit'        => $paidInterest,
                            'debit'        => 0,
                            'desc'        => 'ចំណូលបានមកពីការប្រាក់ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => 0,
                            'debit'        => $paidInterest,
                            'desc'        => 'ចំណូលបានមកពីការប្រាក់ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                    }
                    if($paidPenalty>0)
                    {
                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $penalty->id,
                            'credit'        => $paidPenalty,
                            'debit'        => 0,
                            'desc'        => 'ចំណូលបានមកពីប្រាក់ពិន័យ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => 0,
                            'debit'        => $paidPenalty,
                            'desc'        => 'ចំណូលបានមកពីប្រាក់ពិន័យ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                    }
                    if($paidRisk>0)
                    {
                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $risk->id,
                            'credit'        => $paidRisk,
                            'debit'        => 0,
                            'desc'        => 'ចំណូលបានមកពីសេវាប្រតិបត្តិការ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => 0,
                            'debit'        => $paidRisk,
                            'desc'        => 'ចំណូលបានមកពីសេវាប្រតិបត្តិការ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                    }
                    if($paidMaintenance>0)
                    {
                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $maintenance->id,
                            'credit'        => $paidMaintenance,
                            'debit'        => 0,
                            'desc'        => 'ចំណូលបានមកពីសេវាធានា បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => 0,
                            'debit'        => $paidMaintenance,
                            'desc'        => 'ចំណូលបានមកពីសេវាធានា បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                    }
                    if($totalService>0)
                    {
                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $service->id,
                            'credit'        => $totalService,
                            'debit'        => 0,
                            'desc'        => 'ចំណូលបានមកពីសេវារដ្ឋបាល បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => 0,
                            'debit'        => $totalService,
                            'desc'        => 'ចំណូលបានមកពីសេវារដ្ឋបាល បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                    }
                    if($totalCollection>0)
                    {
                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $hanipei->id,
                            'credit'        => $totalCollection,
                            'debit'        => 0,
                            'desc'        => 'ចំណូលបានមកពីសេវាហានិភ័យ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => 0,
                            'debit'        => $totalCollection,
                            'desc'        => 'ចំណូលបានមកពីសេវាហានិភ័យ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                    }
                    if($rescheduleTotal>0)
                    {
                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $reschedule->id,
                            'credit'        => $rescheduleTotal,
                            'debit'        => 0,
                            'desc'        => 'ចំណូលបានមកពីសេវារដ្ឋរៀបតារាឡើងវិញ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => 0,
                            'debit'        => $rescheduleTotal,
                            'desc'        => 'ចំណូលបានមកពីសេវារដ្ឋរៀបតារាឡើងវិញ បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                    }

                    //ប្រាក់សន្សំកាត់ពីអតិថិជន
                    if($totalSaving>0)
                    {
                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $saving->id,
                            'credit'        => $totalSaving,
                            'debit'        => 0,
                            'desc'        => 'ចំណូលកាត់ប្រាក់សន្សំពីអតិថិជន បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => 0,
                            'debit'        => $totalSaving,
                            'desc'        => 'ចំណូលកាត់ប្រាក់សន្សំពីអតិថិជន បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $saving_client->id,
                            'credit'        => 0,
                            'debit'        => $totalSaving,
                            'desc'        => 'សង់ប្រាក់សន្សំទៅអតិថិជន បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => $totalSaving,
                            'debit'        => 0,
                            'desc'        => 'សង់ប្រាក់សន្សំទៅអតិថិជន បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                    }

                    //ប្រាក់សន្សំសង់អតិថិជន
                    if($totalSavingClient>0)
                    {
                        $parent_id=Journal::max('parent_id');
                        $max = $parent_id==null?1:$parent_id;
                        $user = User::find(Auth::user()->id);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $saving_client->id,
                            'credit'        => 0,
                            'debit'        => $totalSavingClient,
                            'desc'        => 'សង់ប្រាក់សន្សំទៅអតិថិជន បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);
                        Journal::Create([
                            'payment_model_type'        => get_class($payment_method),
                            'payment_model_id'        => $payment_method->id,
                            'branch_id' => Auth::user()->branch_id,
                            'created_by'        => Auth::user()->id,
                            'currency_id' => Auth::user()->currency_id,
                            'journal_date'        => $today,
                            'parent_id'        => $max+1,
                            'chart_of_acc_id'        => $cash->id,
                            'credit'        => $totalSavingClient,
                            'debit'        => 0,
                            'desc'        => 'សង់ប្រាក់សន្សំទៅអតិថិជន បិទបញ្ចីដោយ '.$user->name.'',
                            'status'        => 1
                        ]);

                    }
                DB::commit();
                $res = [
                    'status' => 1,
                    'message'=> 'បិទបញ្ចីបានដោយជោគជ័យ',
                    // 'data'   => ShowPaymentResource::collection($data)
                ];
            }catch(Exception $e){
                DB::rollBack();
                $res = [
                    'status'  => 0,
                    'message' => 'បិទបញ្ចីមិនជោគជ័យ',
                    'data'    => $e->getMessage()
                ];
            }
            return response()->json($res,200);
    }
    public function store(Request $request)
    {
        // dd($request->all());
        // try{
        //     DB::beginTransaction();
            $acc_id = $request->id;
            $amount_repay = $request->amount_repay;
            $waiv_penalty = $request->waiv_penalty;
            $penalty = $request->paid_penalty;
            $paid_penalty = $penalty - $waiv_penalty;

            $acc = AccReceivables::find($acc_id);
            $findLoan = Loan::find($acc->loan_id);

            $unreceived = $acc->unreceived;
            $interest_per_month = $acc->interest_per_month;
            $risk_per_month = $acc->risk_per_month;
            $maintenance_per_month = $acc->maintenance_per_month;
            $total_amount =  $request->amount_repay;
            $received_date = $request->received_date;
            $payment_method = $request->payment_method;
            $interest = 0;
            $risk = 0;
            $maintenance = 0;
            $this->validate($request, [
                'received_date' => 'required',
                'amount_repay' => 'required|numeric|gte:'.'1'.'|lte:'.$findLoan->loan_balance,
            ]);
            $update_loan = Loan::find($acc->loan_id);
            if($amount_repay==$unreceived || $amount_repay<$unreceived)
            {
                $accReceivable = AccReceivables::find($acc_id);
                $accReceivable->received_date =  $received_date!=null?date('Y-m-d',strtotime($received_date)):date('Y-m-d');
                $accReceivable->increment('received',$amount_repay);
                $accReceivable->decrement('unreceived',$amount_repay);
                $accReceivable->increment('penalty',$paid_penalty);
                $accReceivable->increment('waiv_penalty',$waiv_penalty);
                $accReceivable->update();

                if($amount_repay==$unreceived){
                    $accReceivable->payment_status_id = 1; // Paids
                    $accReceivable->update();
                    $abc = AccReceivables::where('loan_id',$acc->loan_id)->where('payment_status_id',3)->orderBy('payment_date','asc')->first();
                    if($abc)
                    {
                        $abc->open_close = 2;
                        $abc->update();
                    }

                }else{
                    $accReceivable->payment_status_id = 2;//Patail
                }
                $accReceivable->update();
                $sumInterest = AccReceivableDetails::where('acc_id',$acc_id)->sum('paid_interest');
                if($sumInterest<$interest_per_month)
                {
                    $subInterest = $interest_per_month-$sumInterest;
                    if($total_amount<=$subInterest)
                    {
                        $paid_interest = $total_amount;
                        $paid_principal = 0;
                        $paid_risk = 0;
                        $paid_maintenance = 0;
                    }
                    else
                    {
                        $paid_interest = $subInterest;
                        $paid_principal = 0;
                        $paid_maintenance = 0;
                        $total_amount = $total_amount-$paid_interest;
                        $sumRisk = AccReceivableDetails::where('acc_id',$acc_id)->sum('paid_risk');
                        $subRisk = $risk_per_month-$sumRisk;
                        if($total_amount<=$subRisk)
                        {
                            $paid_principal = 0;
                            $paid_risk = $total_amount;
                            $paid_maintenance = 0;
                        }
                        else
                        {
                            $paid_risk = $subRisk;
                            $paid_principal = 0;
                            $total_amount = $total_amount-$paid_risk;
                            $sumMaintenance = AccReceivableDetails::where('acc_id',$acc_id)->sum('paid_maintenance');
                            $subMaintenance = $maintenance_per_month-$sumMaintenance;
                            if($sumMaintenance<$maintenance_per_month)
                            {
                                if($total_amount<=$subMaintenance)
                                {
                                    $paid_principal = 0;
                                    $paid_maintenance = $total_amount;
                                }
                                else
                                {
                                    $paid_maintenance = $subMaintenance;
                                    $paid_principal = $total_amount-$subMaintenance;
                                }
                            }
                            else
                            {
                                $paid_principal = $total_amount;
                            }
                        }
                    }
                }
                else
                {
                    $sumRisk = AccReceivableDetails::where('acc_id',$acc_id)->sum('paid_risk');
                    $subRisk = $risk_per_month-$sumRisk;
                    if($sumRisk<$risk_per_month)
                    {
                        if($total_amount<=$subRisk)
                        {
                            $paid_principal = 0;
                            $paid_interest = 0;
                            $paid_risk = $total_amount;
                            $paid_maintenance = 0;
                        }
                        else
                        {
                            $paid_principal = 0;
                            $paid_interest = 0;
                            $paid_risk = $subRisk;
                            $total_amount = $total_amount-$subRisk;
                            $sumMaintenance = AccReceivableDetails::where('acc_id',$acc_id)->sum('paid_maintenance');
                            $subMaintenance = $maintenance_per_month-$sumMaintenance;
                            if($sumMaintenance<$maintenance_per_month)
                            {
                                if($total_amount<=$subMaintenance)
                                {
                                    $paid_principal = 0;
                                    $paid_interest = 0;
                                    $paid_maintenance = $total_amount;
                                }
                                else
                                {
                                    $paid_interest = 0;
                                    $paid_maintenance = $subMaintenance;
                                    $paid_principal = $total_amount-$subMaintenance;
                                }
                            }
                            else
                            {
                                $paid_principal = $total_amount;
                            }
                        }
                    }
                    else
                    {

                        $paid_principal = 0;
                        $paid_interest = 0;
                        $paid_risk = 0;
                        $sumMaintenance = AccReceivableDetails::where('acc_id',$acc_id)->sum('paid_maintenance');
                        $subMaintenance = $maintenance_per_month-$sumMaintenance;
                        if($sumMaintenance<$maintenance_per_month)
                        {
                            if($total_amount<=$subMaintenance)
                            {
                                $paid_principal = 0;
                                $paid_interest = 0;
                                $paid_risk = 0;
                                $paid_maintenance = $total_amount;
                            }
                            else
                            {
                                $paid_interest = 0;
                                $paid_risk = 0;
                                $paid_maintenance = $subMaintenance;
                                $paid_principal = $total_amount-$subMaintenance;
                            }
                        }
                        else
                        {
                            $paid_interest = 0;
                            $paid_risk = 0;
                            $paid_maintenance = 0;
                            $paid_principal = $total_amount;
                        }
                    }
                }



                $accReceivableDetail = new AccReceivableDetails();
                $accReceivableDetail->acc_id = $acc->id;
                $accReceivableDetail->client_id = $acc->client_id;
                $accReceivableDetail->co_id = $acc->co_id;
                $accReceivableDetail->branch_id = $acc->branch_id;
                $accReceivableDetail->loan_id = $acc->loan_id;
                $accReceivableDetail->currency_id = $acc->currency_id;
                $accReceivableDetail->received_date = date('Y-m-d',strtotime($received_date));
                $accReceivableDetail->received =$amount_repay;
                $accReceivableDetail->paid_principal =$paid_principal;
                $accReceivableDetail->paid_interest = $paid_interest;
                $accReceivableDetail->paid_risk = $paid_risk;
                $accReceivableDetail->paid_maintenance = $paid_maintenance;
                $accReceivableDetail->waiv_penalty = $waiv_penalty;
                $accReceivableDetail->payment_method = $payment_method;
                $accReceivableDetail->condition_payment = 1;
                $accReceivableDetail->paid_penalty =$paid_penalty;
                $accReceivableDetail->unreceived=$accReceivable->unreceived;
                $accReceivableDetail->save();

                $update_loan->increment('paid_principal',$paid_principal);
                $update_loan->increment('paid_interest',$paid_interest);
                $update_loan->increment('paid_risk',$paid_risk);
                $update_loan->increment('paid_maintenance',$paid_maintenance);
                $update_loan->decrement('balance_principal',$paid_principal);
                $update_loan->decrement('balance_interest',$paid_interest);
                $update_loan->decrement('balance_risk',$paid_risk);
                $update_loan->decrement('balance_maintenance',$paid_maintenance);
                $update_loan->update();
            }
            else
            {
                $AccReceived = AccReceivables::whereIn('payment_status_id',[2,3])->where('loan_id',$acc->loan_id)->orderBy('payment_date','ASC')->get();
                $lastUnreceived = 0;
                $firstAccId= $AccReceived->min('id');
                $pay = 0;
                foreach($AccReceived as $key=>$value)
                {
                    $lastUnreceived +=$value['unreceived'];
                    $pay = $lastUnreceived-$amount_repay;
                    if($amount_repay > $lastUnreceived){

                        if($value->id == $firstAccId)
                        {
                            $penalty =$paid_penalty;
                            $penalty_waiv =$waiv_penalty;
                        }else
                        {
                            $penalty = 0;
                            $penalty_waiv =0;
                        }

                        $AccEqual = AccReceivables::find($value->id);
                        $UnAcc = AccReceivables::find($value->id);
                        $AccEqual->received_date = date('Y-m-d',strtotime($request->received_date));
                        $AccEqual->payment_status_id = 1;
                        $AccEqual->open_close = 2;

                        $abc = AccReceivables::where('loan_id',$acc->loan_id)->where('payment_status_id',3)->orderBy('payment_date','asc')->first();
                        if($abc)
                        {
                            $abc->open_close = 2;
                            $abc->update();
                        }
                        // $check = AccReceivables::where('id',$value->id)->orderBy('payment_date','asc')->first();
                        // if($check->payment_status_id == 3)
                        $check = AccReceivables::where('id',$value->id)->orderBy('payment_date','asc')->first();
                        if($check->unreceived == $check->payment_per_month)
                        {
                            $AccEqual->increment('received',$value['unreceived']);
                            $AccEqual->decrement('unreceived',$value['unreceived']);
                            $AccEqual->update();
                            $accReceivableDetail = new AccReceivableDetails();
                            $accReceivableDetail->acc_id = $value->id;
                            $accReceivableDetail->client_id = $value->client_id;
                            $accReceivableDetail->co_id = $value->co_id;
                            $accReceivableDetail->branch_id = $value->branch_id;
                            $accReceivableDetail->loan_id = $value->loan_id;
                            $accReceivableDetail->currency_id = $value->currency_id;
                            $accReceivableDetail->received_date = date('Y-m-d',strtotime($received_date));
                            $accReceivableDetail->received = $value['unreceived'];
                            $accReceivableDetail->paid_principal = $value['principal'];
                            $accReceivableDetail->paid_interest = $value['interest_per_month'];
                            $accReceivableDetail->paid_risk = $value['risk_per_month'];
                            $accReceivableDetail->waiv_penalty = $penalty_waiv;
                            $accReceivableDetail->paid_maintenance = $value['maintenance_per_month'];
                            $accReceivableDetail->payment_method = $payment_method;
                            $accReceivableDetail->condition_payment = 1;
                            $accReceivableDetail->paid_penalty = $paid_penalty;
                            $accReceivableDetail->unreceived= 0;
                            $accReceivableDetail->save();

                            $update_loan->increment('paid_principal',$value['principal']);
                            $update_loan->increment('paid_interest',$value['interest_per_month']);
                            $update_loan->increment('paid_risk',$value['risk_per_month']);
                            $update_loan->increment('paid_maintenance',$value['maintenance_per_month']);
                            $update_loan->decrement('balance_principal',$value['principal']);
                            $update_loan->decrement('balance_interest',$value['interest_per_month']);
                            $update_loan->decrement('balance_risk',$value['risk_per_month']);
                            $update_loan->decrement('balance_maintenance',$value['maintenance_per_month']);
                            $update_loan->update();
                        }
                        else
                        {

                            $receivedInterest = AccReceivableDetails::where('acc_id',$value->id)->sum('paid_interest');
                            $receivedRisk = AccReceivableDetails::where('acc_id',$value->id)->sum('paid_risk');
                            $receivedMaintenance = AccReceivableDetails::where('acc_id',$value->id)->sum('paid_maintenance');
                            $receivedPrincipal = AccReceivableDetails::where('acc_id',$value->id)->sum('paid_principal');
                            $interest = $UnAcc->interest_per_month-$receivedInterest;
                            $risk = $UnAcc->risk_per_month-$receivedRisk;
                            $maintenance = $UnAcc->maintenance_per_month-$receivedMaintenance;
                            $principal = $UnAcc->principal-$receivedPrincipal;

                            if($value->currency_id == 1)
                            {
                                $paid_interest = round($interest/100)*100;
                                $paid_risk = round($risk/100)*100;
                                $paid_maintenance = round($maintenance/100)*100;
                                $paid_principal = round($principal/100)*100;
                            }
                            else
                            {
                                $paid_interest = round($interest,2);
                                $paid_risk = round($risk,2);
                                $paid_maintenance = round($maintenance,2);
                                $paid_principal = round($principal,2);
                            }
                            $AccEqual->increment('received',$value['unreceived']);
                            $AccEqual->decrement('unreceived',$value['unreceived']);
                            $AccEqual->update();

                            $accReceivableDetail = new AccReceivableDetails();
                            $accReceivableDetail->acc_id = $value->id;
                            $accReceivableDetail->client_id = $value->client_id;
                            $accReceivableDetail->co_id = $value->co_id;
                            $accReceivableDetail->branch_id = $value->branch_id;
                            $accReceivableDetail->loan_id = $value->loan_id;
                            $accReceivableDetail->currency_id = $value->currency_id;
                            $accReceivableDetail->received_date = date('Y-m-d',strtotime($request->received_date));
                            $accReceivableDetail->received = $UnAcc->unreceived;
                            $accReceivableDetail->paid_principal =  $paid_principal;
                            $accReceivableDetail->paid_interest = $paid_interest;
                            $accReceivableDetail->paid_risk = $paid_risk;
                            $accReceivableDetail->paid_maintenance = $paid_maintenance;
                            $accReceivableDetail->payment_method = $payment_method;
                            $accReceivableDetail->condition_payment = 1;
                            $accReceivableDetail->unreceived= $AccEqual->unreceived;
                            $accReceivableDetail->save();

                            $update_loan->increment('paid_principal',$paid_principal);
                            $update_loan->increment('paid_interest',$paid_interest);
                            $update_loan->increment('paid_risk',$paid_risk);
                            $update_loan->increment('paid_maintenance',$paid_maintenance);
                            $update_loan->decrement('balance_principal',$paid_principal);
                            $update_loan->decrement('balance_interest',$paid_interest);
                            $update_loan->decrement('balance_risk',$paid_risk);
                            $update_loan->decrement('balance_maintenance',$paid_maintenance);
                            $update_loan->update();

                        }


                    }
                    else if($amount_repay == $lastUnreceived){
                        $AccEqual = AccReceivables::find($value->id);
                        $AccEqual->received_date = date('Y-m-d',strtotime($request->received_date));
                        $AccEqual->payment_status_id = 1;
                        $AccEqual->open_close = 2;
                        $AccEqual->update();
                        $abc = AccReceivables::where('loan_id',$acc->loan_id)->where('payment_status_id',3)->orderBy('payment_date','asc')->first();
                        if($abc)
                        {
                            $abc->open_close = 2;
                            $abc->update();
                        }
                        $AccEqual->increment('received',$value['unreceived']);
                        $AccEqual->decrement('unreceived',$value['unreceived']);
                        $AccEqual->update();

                        $accReceivableDetail = new AccReceivableDetails();
                        $accReceivableDetail->acc_id = $value->id;
                        $accReceivableDetail->client_id = $value->client_id;
                        $accReceivableDetail->co_id = $value->co_id;
                        $accReceivableDetail->branch_id = $value->branch_id;
                        $accReceivableDetail->loan_id = $value->loan_id;
                        $accReceivableDetail->currency_id = $value->currency_id;
                        $accReceivableDetail->received_date = date('Y-m-d',strtotime($received_date));
                        $accReceivableDetail->received = $value['unreceived'];
                        $accReceivableDetail->paid_principal = $value['principal'];
                        $accReceivableDetail->paid_interest = $value['interest_per_month'];
                        $accReceivableDetail->paid_risk = $value['risk_per_month'];
                        $accReceivableDetail->paid_maintenance = $value['maintenance_per_month'];
                        $accReceivableDetail->payment_method = $payment_method;
                        $accReceivableDetail->condition_payment = 1;
                        $accReceivableDetail->paid_penalty = $paid_penalty;
                        $accReceivableDetail->waiv_penalty = $waiv_penalty;
                        $accReceivableDetail->unreceived= 0;
                        $accReceivableDetail->save();

                        $update_loan->increment('paid_principal',$value['principal']);
                        $update_loan->increment('paid_interest',$value['interest_per_month']);
                        $update_loan->increment('paid_risk',$value['risk_per_month']);
                        $update_loan->increment('paid_maintenance',$value['maintenance_per_month']);
                        $update_loan->decrement('balance_principal',$value['principal']);
                        $update_loan->decrement('balance_interest',$value['interest_per_month']);
                        $update_loan->decrement('balance_risk',$value['risk_per_month']);
                        $update_loan->decrement('balance_maintenance',$value['maintenance_per_month']);
                        $update_loan->update();

                        break 1;


                    }
                    else{
                        $lastPay = $value['unreceived']-$pay;
                        $updateAcc = AccReceivables::find($value->id);
                        $updateAcc->payment_status_id=2;
                        $updateAcc->received_date=date('Y-m-d',strtotime($received_date));
                        $updateAcc->open_close = 2;
                        $updateAcc->increment('received',$lastPay);
                        $updateAcc->decrement('unreceived',$lastPay);
                        $updateAcc->update();

                        if($lastPay <= $updateAcc->interest_per_month) {
                            $paid_interest    = $lastPay;
                            $paid_principal   = 0;
                            $paid_risk        = 0;
                            $paid_maintenance = 0;
                        } else{
                            $paid_interest    = $updateAcc->interest_per_month; // Find paid interest
                            $paid_risk        = 0;
                            $paid_principal   = 0;
                            $paid_maintenance = 0;
                            $remain_principal = $lastPay - $paid_interest; // Amount remain after sub paid interest
                            if($remain_principal <= $updateAcc->risk_per_month) {
                                $paid_risk        = $remain_principal;  // Find paid risk
                                $paid_principal   = 0;
                                $paid_maintenance = 0;
                            } else {
                                $paid_risk      = $updateAcc->risk_per_month;  // Find paid risk
                                $paid_principal = 0;
                                $remain_risk    = $remain_principal - $paid_risk; // Amount remain after sub paid risk
                                if($remain_risk <= $updateAcc->maintenance_per_month) {
                                    $paid_principal   = 0;
                                    $paid_maintenance = $remain_risk;  // Find paid maintenance
                                } else {
                                    $paid_maintenance = $updateAcc->maintenance_per_month;  // Find paid maintenance
                                    $paid_principal   = $remain_risk - $paid_maintenance; // Amount remain after sub paid maintenance
                                }
                            }
                        }

                        $accReceivableDetail = new AccReceivableDetails();
                        $accReceivableDetail->acc_id = $value->id;
                        $accReceivableDetail->client_id = $value->client_id;
                        $accReceivableDetail->co_id = $value->co_id;
                        $accReceivableDetail->branch_id = $value->branch_id;
                        $accReceivableDetail->loan_id = $value->loan_id;
                        $accReceivableDetail->currency_id = $value->currency_id;
                        $accReceivableDetail->received_date = date('Y-m-d',strtotime($received_date));
                        $accReceivableDetail->received =  $lastPay;
                        $accReceivableDetail->paid_principal = $paid_principal;
                        $accReceivableDetail->paid_interest = $paid_interest;
                        $accReceivableDetail->paid_risk = $paid_risk;
                        $accReceivableDetail->paid_maintenance = $paid_maintenance;
                        $accReceivableDetail->payment_method = $payment_method;
                        $accReceivableDetail->condition_payment = 1;
                        $accReceivableDetail->waiv_penalty = $waiv_penalty;
                        $accReceivableDetail->unreceived= $pay;
                        $accReceivableDetail->save();

                        $update_loan->increment('total_waiv',$waiv_penalty);
                        $update_loan->increment('paid_principal',$paid_principal);
                        $update_loan->increment('paid_interest',$paid_interest);
                        $update_loan->increment('paid_risk',$paid_risk);
                        $update_loan->increment('paid_maintenance',$paid_maintenance);
                        $update_loan->decrement('balance_principal',$paid_principal);
                        $update_loan->decrement('balance_interest',$paid_interest);
                        $update_loan->decrement('balance_risk',$paid_risk);
                        $update_loan->decrement('balance_maintenance',$paid_maintenance);
                        $update_loan->update();

                        break 1;
                    }
                }
            }

            $update_loan->increment('loan_in',$amount_repay);
            $update_loan->decrement('loan_balance',$amount_repay);
            $update_loan->increment('total_penalty',$paid_penalty);
            $update_loan->increment('total_waiv',$waiv_penalty);
            $update_loan->update();
            if( $update_loan->loan_balance == 0 || $update_loan->loan_balance <= 0.1)
            {
                $update_loan->loan_status_id = 3;
                $update_loan->completed_date = date('Y-m-d');
                $update_loan->loan_balance =0;
            }

            $update_loan->update();
            $user = User::find(Auth::user()->id);
            $client = Client::find($acc->client_id);
            $subject = "អតិថិជន $client->name ធ្វើការបង់ប្រាក់ចំនួន $amount_repay ដោយ $user->name.";
            $subject_type = get_class($acc);
            $subject_id = $acc->id;
            $causer_type = get_class($user);
            $causer_id = Auth::user()->id;
            $branch = Auth::user()->branch_id;
            $log_name = 'AccReceivable Model';
            LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);

            $res = [
                'status' => 1,
                'message'=> 'Payment success',
                // 'data'   => ShowPaymentResource::collection($data)
            ];
        //     DB::commit();
        // }catch(Exception $e){
        //     DB::rollBack();
        //     $res = [
        //         'status'  => 0,
        //         'message' => 'Payment not success',
        //         'data'    => $e->getMessage(),
        //     ];
        // }
        return response()->json($res,200);
    }

    public function update(Request $request,$id)
    {
            // dd($id);
        try{
            DB::beginTransaction();
            $det = AccReceivableDetails::find($id);
            $amount_repay = $request->amount_repay;
            $penalty = $request->paid_penalty;
            $waiv_penalty = $request->waiv_penalty;
            $paid_penalty = $penalty-$waiv_penalty;
            $acc = AccReceivables::find($det->acc_id);

            $interest_per_month = $acc->interest_per_month;
            $risk_per_month = $acc->risk_per_month;
            $maintenance_per_month = $acc->maintenance_per_month;
            $payment_per_month = $acc->payment_per_month;
            $received_date = $request->received_date;
            $payment_method = $request->payment_method;

            $update_loan = Loan::find($acc->loan_id);
            $accReceivable = AccReceivables::find($det->acc_id);
            $accReceivable->received_date =  $received_date!=null?date('Y-m-d',strtotime($received_date)):date('Y-m-d');
            // $accReceivable->decrement('received',$det->received);
            // $accReceivable->increment('unreceived',$det->received);
            // $accReceivable->decrement('penalty',$det->paid_penalty);
            // $accReceivable->decrement('waiv_penalty',$det->waiv_penalty);
            // $accReceivable->increment('received',$amount_repay);
            // $accReceivable->decrement('unreceived',$amount_repay);
            // $accReceivable->increment('penalty',$paid_penalty);
            // $accReceivable->increment('waiv_penalty',$waiv_penalty);

            // update 14/07/2025
            // Decrease
            $accReceivable->received    -= $det->received;
            $accReceivable->unreceived  -= $amount_repay;
            $accReceivable->penalty     -= $det->paid_penalty;
            $accReceivable->waiv_penalty-= $det->waiv_penalty;
            // Increase
            $accReceivable->received    += $amount_repay;
            $accReceivable->unreceived  += $det->received;
            $accReceivable->penalty     += $paid_penalty;
            $accReceivable->waiv_penalty+= $waiv_penalty;

            $accReceivable->update();

            $update = AccReceivables::find($det->acc_id);
            if($update->unreceived==0){
                $accReceivable->payment_status_id = 1; // Paids
                $accReceivable->update();
                $abc = AccReceivables::where('loan_id',$acc->loan_id)->where('payment_status_id',3)->orderBy('payment_date','asc')->first();
                if($abc)
                {
                    $abc->open_close = 2;
                    $abc->update();
                }

            }else{
                $accReceivable->payment_status_id = 2; //Patail
            }
            $accReceivable->update();
            $update->update();

            $paid_interest = $interest_per_month * $amount_repay / $payment_per_month;
            $paid_risk = $risk_per_month * $amount_repay / $payment_per_month;
            $paid_maintenance = $maintenance_per_month * $amount_repay / $payment_per_month;
            if($acc->currency_id == 1)
            {
                $paid_interest = round($paid_interest,-2,PHP_ROUND_HALF_ODD);
                $paid_risk = round($paid_risk,-2,PHP_ROUND_HALF_ODD);
                $paid_maintenance = round($paid_maintenance,-2,PHP_ROUND_HALF_ODD);
                $paid_principal = $amount_repay-$paid_interest-$paid_risk-$paid_maintenance;
            }
            else
            {
                $paid_interest = round($paid_interest,2);
                $paid_risk = round($paid_risk,2);
                $paid_maintenance = round($paid_maintenance,2);
                $paid_principal = $amount_repay-$paid_interest-$paid_risk-$paid_maintenance;
            }

            $accReceivableDetail = AccReceivableDetails::find($id);
            $accReceivableDetail->received_date = date('Y-m-d',strtotime($received_date));
            $accReceivableDetail->received =$amount_repay;
            $accReceivableDetail->paid_principal =$paid_principal;
            $accReceivableDetail->paid_interest = $paid_interest;
            $accReceivableDetail->paid_risk = $paid_risk;
            $accReceivableDetail->paid_maintenance = $paid_maintenance;
            $accReceivableDetail->payment_method = $payment_method;
            $accReceivableDetail->condition_payment = 1;
            $accReceivableDetail->paid_penalty =$paid_penalty;
            $accReceivableDetail->waiv_penalty =$waiv_penalty;
            $accReceivableDetail->unreceived=$accReceivable->unreceived;
            $accReceivableDetail->update();


            $update_loan->decrement('paid_principal',$det->paid_principal);
            $update_loan->decrement('paid_interest',$det->paid_interest);
            $update_loan->decrement('paid_risk',$det->paid_risk);
            $update_loan->decrement('paid_maintenance',$det->paid_maintenance);

            $update_loan->increment('balance_principal',$det->paid_principal);
            $update_loan->increment('balance_interest',$det->paid_interest);
            $update_loan->increment('balance_risk',$det->paid_risk);
            $update_loan->increment('balance_maintenance',$det->paid_maintenance);

            $update_loan->decrement('loan_in',$det->received);
            $update_loan->increment('loan_balance',$det->received);
            $update_loan->decrement('total_penalty',$det->paid_penalty);
            $update_loan->decrement('total_waiv',$det->waiv_penalty);

            $update_loan->increment('paid_principal',$paid_principal);
            $update_loan->increment('paid_interest',$paid_interest);
            $update_loan->increment('paid_risk',$paid_risk);
            $update_loan->increment('paid_maintenance',$paid_maintenance);
            $update_loan->decrement('balance_principal',$paid_principal);
            $update_loan->decrement('balance_interest',$paid_interest);
            $update_loan->decrement('balance_risk',$paid_risk);
            $update_loan->decrement('balance_maintenance',$paid_maintenance);
            $update_loan->increment('loan_in',$amount_repay);
            $update_loan->decrement('loan_balance',$amount_repay);
            $update_loan->increment('total_penalty',$paid_penalty);
            $update_loan->increment('total_waiv',$waiv_penalty);

            $update_loan->update();

            if( $update_loan->loan_balance == 0 || $update_loan->loan_balance <= 0.1)
            {
                $update_loan->loan_status_id = 3;
                $update_loan->completed_date = date('Y-m-d');
                $update_loan->loan_balance =0;
            }
            $update_loan->update();

            $user = User::find(Auth::user()->id);
            $client = Client::find($acc->client_id);
            $subject = "កែប្រែការបង់ប្រាក់របស់អតិថិជន $client->name ដោយ $user->name.";
            $subject_type = get_class($det);
            $subject_id = $det->id;
            $causer_type = get_class($user);
            $causer_id = Auth::user()->id;
            $branch = Auth::user()->branch_id;
            $log_name = 'AccReceivableDetail Model';
            LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
            $res = [
                'status' => 1,
                'message'=> "កែប្រែការបង់ប្រាក់របស់អតិថិជន $client->name ដោយជោគជ័យ",
                // 'data'   => ShowPaymentResource::collection($data)
            ];
            DB::commit();
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => "កែប្រែការបង់ប្រាក់របស់អតិថិជន $client->name ដោយមិនជោគជ័យ",
                'data'    => $e->getMessage(),
            ];
        }
        return response()->json($res,200);
    }
    public function show($id)
    {
        $data = AccReceivableDetails::where('acc_id',$id)
        ->whereIn('branch_id',Helper::byBranch())
        ->where('currency_id',Helper::byCurrency())
        ->get();
        return CollectedResource::collection($data);
    }

    public function Approve(Request $request)
    {
        $check = $request->checkBox;
        DB::beginTransaction();
        try {
            // $user = User::find(Auth::user()->id);
            // $subject = "បេឡាទទួលប្រាក់ពីមន្រ្តីឥណទាន ដោយ $user->name.";
            // $subject_type = get_class($acc);
            // $subject_id = $acc->id;
            // $causer_type = get_class($user);
            // $causer_id = Auth::user()->id;
            // $branch = Auth::user()->branch_id;
            // $log_name = 'AccReceivableDetail Model';
            // LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
            foreach($check as $key =>$value){
                $acc = AccReceivableDetails::where('id',$value['id'])->update([
                    'status' => 2,
                    'approved_by' => Auth::user()->id,
                ]);
                $user = User::find(Auth::user()->id);
                $acc = AccReceivableDetails::where('id',$value['id'])->first();
                $subject = "បេឡាទទួលប្រាក់ពីមន្រ្តីឥណទាន ដោយ $user->name.";
                $subject_type = get_class($acc);
                $subject_id =$acc->id;
                $causer_type = get_class($user);
                $causer_id = Auth::user()->id;
                $branch = Auth::user()->branch_id;
                $log_name = 'AccReceivableDetail Model';
                LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
            }
            $res = [
                'status' => 1,
                'message'=> 'Approve success',
                'data'   => $acc,
            ];
            DB::commit();
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Approve not success',
                'data'    => $e->getMessage(),
            ];
        }
        return response()->json($res,200);
    }

    public function destroy($id)
    {
        // dd($id);
        DB::beginTransaction();
        try {


            $detail = AccReceivableDetails::find($id);
            $acc = AccReceivables::find($detail->acc_id);
            $loan = Loan::find($detail->loan_id);
            $loan->increment('loan_balance',$detail->received);
            $loan->decrement('loan_in',$detail->received);
            $loan->decrement('paid_principal',$detail->paid_principal);
            $loan->decrement('paid_interest',$detail->paid_interest);
            $loan->decrement('paid_risk',$detail->paid_risk);
            $loan->decrement('paid_maintenance',$detail->paid_maintenance);
            $loan->increment('balance_principal',$detail->paid_principal);
            $loan->increment('balance_interest',$detail->paid_interest);
            $loan->increment('balance_risk',$detail->paid_risk);
            $loan->increment('balance_maintenance',$detail->paid_maintenance);
            $loan->decrement('total_penalty',$detail->paid_penalty);
            $loan->decrement('total_waiv',$detail->waiv_penalty);
            $loan->update();

            $acc->increment('unreceived',$detail->received);
            $acc->decrement('received',$detail->received);
            $acc->decrement('penalty',$detail->paid_penalty);
            $acc->decrement('waiv_penalty',$detail->waiv_penalty);

            if($acc->received==0)
            {
                $acc->payment_status_id = 3;
                $acc->received_date = null;
            }
            else
            {
                $acc->payment_status_id = 2;
            }
            $acc->update();
            $acc_num = $acc->num+1;
            $next = AccReceivables::where('num',$acc_num)->where('loan_id',$acc->loan_id)->first();
            if($next)
            {
                if($next->payment_status_id ==3)
                {
                    $next->open_close = 1;
                    $next->update();
                }
            }
            $update_loan = Loan::find($loan->id);
            if( $update_loan->loan_balance > 0)
            {
                $update_loan->loan_status_id = 2;
                $update_loan->completed_date = null;
                $update_loan->update();
            }
            AccReceivableDetails::where('id',$id)->delete();
            $user = User::find(Auth::user()->id);
            $client = Client::find($acc->client_id);
            $subject = "លុបការបង់ប្រាក់របស់អតិថិជន $client->name ដោយ $user->name.";
            $subject_type = get_class($acc);
            $subject_id = $acc->id;
            $causer_type = get_class($user);
            $causer_id = Auth::user()->id;
            $branch = Auth::user()->branch_id;
            $log_name = 'AccReceivables Model';
            LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
            $res = [
                'status' => 1,
                'message'=> 'Deleted success',
                'data'   => ''
            ];
            DB::commit();
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Deleted not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);
    }
    public function Notification()
    {
        $now = date('Y-m-d');
        $late = AccReceivables::whereIn('payment_status_id',[2,3])
           ->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<',date('Y-m-d'))
            ->whereIn('branch_id',Helper::byBranch())
            ->where('currency_id',Helper::byCurrency())
            ->whereHas('co', function ($query) {
                $query->where('status',1);
            })
            ->whereHas('client', function ($query) {
                $query->where('status',1);
            })
            ->groupBy('loan_id')
            ->get()->count();
        $today = AccReceivables::whereIn('payment_status_id',[2,3])
        ->where('payment_date',$now)
        ->whereIn('branch_id',Helper::byBranch())
        ->where('currency_id',Helper::byCurrency())
        ->groupBy('client_id')->get()->count();
        $approve = Loan::where('loan_status_id',1)
        ->whereIn('branch_id',Helper::byBranch())
        ->where('currency_id',Helper::byCurrency())->count();
        return array(
            'late' => $late,
            'today' => $today,
            'approve' => $approve
        );
    }
    public function ShowPayAll($id)
    {
        $loan = Loan::find($id);
        $AccountInterest = 0;
        $AccountRisk = 0;
        $AccountMaintenance = 0;
        $penalty_payoff = 0;
        $data = AccReceivables::where('loan_id',$id)->whereIn('payment_status_id',[1,2,3])->orderBy('payment_date','asc')->get();
        $totalPrincipal = AccReceivables::where('loan_id',$id)->sum('principal');
        $PaidPrincipal = AccReceivableDetails::where('loan_id',$id)->sum('acc_receivable_details.paid_principal');
        $sum_principal = $totalPrincipal-$PaidPrincipal;
        $count = $data->count();
        $count = ceil($count/2);
        $Amount = AccReceivables::where('loan_id',$id)->whereIn('payment_status_id',[2,3])->orderBy('payment_date','asc')->first();
        $check_penalty = AccReceivables::where('loan_id',$id)->where('id','<=',$data[($count-1)]['id'])->whereIn('payment_status_id',[2,3])->orderBy('payment_date','asc')->first();
        // dd($check_penalty);
        if($check_penalty)
        {
            $penalty_payoff = $Amount->loan_balance*0.1;
        }
        else
        {
            $penalty_payoff = 0;
        }
        // foreach($data as $key=>$val)
        // {
        //     if($key<=($count-1))
        //     {
        //         $Amount = AccReceivables::where('loan_id',$id)->whereIn('payment_status_id',[2,3])->orderBy('payment_date','asc')->first();
        //         $penalty_payoff = $val->loan_balance*0.1;
        //     }
        //     else
        //     {
        //         $penalty_payoff = 0;
        //     }
        // }
        if($loan->currency_id == 1)
        {
            $sum_principal = round($sum_principal, -2, PHP_ROUND_HALF_ODD);
            $AccountInterest = round($Amount->interest_per_month, -2, PHP_ROUND_HALF_ODD);
            $AccountRisk = round($Amount->risk_per_month, -2, PHP_ROUND_HALF_ODD);
            $AccountMaintenance = round($Amount->maintenance_per_month, -2, PHP_ROUND_HALF_ODD);
            $penalty_payoff = round($penalty_payoff, -2, PHP_ROUND_HALF_ODD);
        }
        else
        {
            $sum_principal = round($sum_principal, 2);
            $AccountInterest = round($AccountInterest, 2);
            $AccountRisk = round($AccountRisk, 2);
            $penalty_payoff = round($penalty_payoff, 2);
        }
        return [
            'sum_principal'=>$sum_principal,
            'AccountInterest'=>$AccountInterest,
            'AccountRisk'=>$AccountRisk,
            'AccountMaintenance'=>$AccountMaintenance,
            'penalty_payoff'=>$penalty_payoff
        ];
    }
    public function SubmitPayAll(Request $request)
    {
        // dd($request->all());
        // try{
        //     DB::beginTransaction();
            $loan_id = $request->id;
            $loan = Loan::find($loan_id);
            $num =AccReceivables::where('loan_id',$loan_id)->max('num');
            $amountPay = $request->amountPay-$request->penalty_payoff;
            $interest = $request->sumInterest;
            $risk = $request->sumRisk;
            $maintenance = $request->sumMaintenance;
            $principal = $request->sumPrincipal;
            $received_date = $request->received_date;
            $payment_method = $request->payment_method;
            $penalty_payoff = $request->penalty_payoff;

            $this->validate($request, [
                'received_date' => 'required',
                'amountPay' => 'required|numeric|gte:'.'1'.'|lte:'.$loan->loan_balance,
            ]);
            $update_loan = Loan::find($loan_id);
            $back = AccReceivables::where('loan_id',$request->id)->where('payment_status_id',3)->get();
            foreach($back as $key=>$val)
            {
                $back = new BackPayment();
                $back->acc_id = $val->id;
                $back->loan_id = $val->loan_id;
                $back->currency_id = $val->currency_id;
                $back->client_id = $val->client_id;
                $back->co_id = $val->co_id;
                $back->branch_id = $val->branch_id;
                $back->payment_date = $val->payment_date;
                $back->num = $val->num;
                $back->interest_per_month = $val->interest_per_month;
                $back->risk_per_month = $val->risk_per_month;
                $back->maintenance_per_month = $val->maintenance_per_month;
                $back->principal = $val->principal;
                $back->loan_balance = $val->loan_balance;
                $back->payment_per_month = $val->payment_per_month;
                $back->unreceived = $val->unreceived;
                $back->payment_status_id = $val->payment_status_id;
                $back->open_close = $val->open_close;
                $back->created_at = $val->created_at;
                $back->updated_at = $val->updated_at;
                $back->save();
            }
            AccReceivables::where('loan_id',$loan_id)->where('payment_status_id',3)->delete();
            AccReceivables::where('loan_id',$loan_id)->where('payment_status_id',2)->update(['payment_status_id' => 5]);
            $accReceivable = new AccReceivables();
            $accReceivable->payment_date =  date('Y-m-d');
            $accReceivable->received_date =  $received_date!=null?date('Y-m-d',strtotime($received_date)):date('Y-m-d');
            $accReceivable->client_id = $loan->client_id;
            $accReceivable->co_id = $loan->co_id;
            $accReceivable->branch_id = $loan->branch_id;
            $accReceivable->loan_id = $loan->id;
            $accReceivable->currency_id = $loan->currency_id;
            $accReceivable->received =$amountPay;
            $accReceivable->unreceived =0;
            $accReceivable->num =$num+1;
            $accReceivable->principal =$principal;
            $accReceivable->penalty =$penalty_payoff;
            $accReceivable->interest_per_month = $interest;
            $accReceivable->risk_per_month = $risk;
            $accReceivable->maintenance_per_month = $maintenance;
            $accReceivable->payment_per_month = $amountPay;
            $accReceivable->payment_status_id = 6;
            $accReceivable->open_close = 2;
            $accReceivable->save();


            $accReceivableDetail = new AccReceivableDetails();
            $accReceivableDetail->acc_id = $accReceivable->id;
            $accReceivableDetail->client_id = $loan->client_id;
            $accReceivableDetail->co_id = $loan->co_id;
            $accReceivableDetail->branch_id = $loan->branch_id;
            $accReceivableDetail->loan_id = $loan->id;
            $accReceivableDetail->currency_id = $loan->currency_id;
            $accReceivableDetail->received_date = date('Y-m-d',strtotime($received_date));
            $accReceivableDetail->received =$amountPay;
            $accReceivableDetail->paid_principal =$principal;
            $accReceivableDetail->paid_interest = $interest;
            $accReceivableDetail->paid_risk = $risk;
            $accReceivableDetail->paid_maintenance = $maintenance;
            $accReceivableDetail->payment_method = $payment_method;
            $accReceivableDetail->paid_penalty = $penalty_payoff;
            $accReceivableDetail->condition_payment = 6;
            $accReceivableDetail->unreceived= 0;
            $accReceivableDetail->save();

            $update_loan->increment('paid_principal', $principal);
            $update_loan->increment('paid_interest', $interest);
            $update_loan->increment('paid_risk', $risk);
            $update_loan->increment('paid_maintenance', $maintenance);
            $update_loan->increment('loan_in',$amountPay);
            $update_loan->increment('total_penalty',$penalty_payoff);
            $update_loan->balance_principal = 0;
            $update_loan->balance_interest = 0;
            $update_loan->balance_risk = 0;
            $update_loan->balance_maintenance = 0;
            $update_loan->loan_balance = 0;
            $update_loan->loan_status_id = 3;
            $update_loan->completed_date = date('Y-m-d');
            $update_loan->loan_balance =0;
            $update_loan->update();

            $user = User::find(Auth::user()->id);
            $client = Client::find($loan->client_id);
            $subject = "អតិថិជន $client->name បង់ប្រាក់ផ្ដាច់ ចំនួន $amountPay ដោយ $user->name.";
            $subject_type = get_class($loan);
            $subject_id = $loan->id;
            $causer_type = get_class($user);
            $causer_id = Auth::user()->id;
            $branch = Auth::user()->branch_id;
            $log_name = 'Loan Model';
            LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
            DB::commit();
            $res = [
                'status' => 1,
                'message'=> 'អតិថិជនបង់ផ្ដាច់ដោយជោគជ័យ',
                // 'data'   => ShowPaymentResource::collection($data)
            ];
        // }catch(Exception $e){
        //     DB::rollBack();
        //     $res = [
        //         'status'  => 0,
        //         'message' => 'អតិថិជនបង់ផ្ដាច់ដោយមិនបានជោគជ័យ',
        //         'data'    => $e->getMessage(),
        //     ];
        // }
        return response()->json($res,200);
    }
    public function adminBackPayment($id)
    {

        try{
            DB::beginTransaction();
            $acc = AccReceivables::find($id);
            $loan_id = $acc->loan_id;
            $principal = 0;
            $interest = 0;
            $risk = 0;
            $maintenance = 0;
            $payment = 0;

            $Back = BackPayment::where('loan_id',$loan_id)->where('status',1)->get();
            foreach($Back as $key=>$val)
            {
                $principal += $val->principal;
                $interest += $val->interest_per_month;
                $risk += $val->risk_per_month;
                $maintenance += $val->maintenance_per_month;
                $payment += $val->payment_per_month;

               AccReceivables::where('id',$val->acc_id)->withTrashed()->update([
                    'deleted_at' => NULL
                ]);
            }
            // $loan = Loan::find($loan_id);
            // $loan->loan_balance = $payment;
            // $loan->balance_principal = $principal;
            // $loan->balance_interest = $interest;
            // $loan->balance_risk = $risk;
            // $loan->balance_maintenance = $maintenance;
            // // $loan->payment_method = 1;
            // $loan->decrement('loan_in',$acc->payment_per_month);
            // $loan->decrement('paid_principal',$acc->principal);
            // $loan->decrement('paid_interest',$acc->interest_per_month);
            // $loan->decrement('paid_risk',$acc->risk_per_month);
            // $loan->decrement('paid_maintenance',$acc->maintenance_per_month);
            // $loan->loan_status_id = 2;
            // $loan->completed_date = null;
            // $loan->update();
            $patail_acc = AccReceivables::where('loan_id',$loan_id)->where('payment_status_id',5)->first();
            if($patail_acc) {
                $paid_principal = AccReceivableDetails::where('acc_id',$patail_acc->id)->sum('paid_principal');
                $paid_interest = AccReceivableDetails::where('acc_id',$patail_acc->id)->sum('paid_interest');
                $paid_risk = AccReceivableDetails::where('acc_id',$patail_acc->id)->sum('paid_risk');

                $unpaid_principal = $patail_acc->principal - $paid_principal;
                $unpaid_interest = $patail_acc->interest_per_month - $paid_interest;
                $unpaid_risk = $patail_acc->risk_per_month - $paid_risk;

                $total_unpaid_principal = $principal + $unpaid_principal;
                $total_unpaid_interest  = $interest + $unpaid_interest;
                $total_unpaid_risk = $risk + $unpaid_risk;
                // Update AccReceivables
                $patail_acc->payment_status_id = 2; // បានបង់ខ្លះ
                $patail_acc->update();
            } else {
                $total_unpaid_principal = $principal;
                $total_unpaid_interest = $interest;
                $total_unpaid_risk = $risk;
            }
            $total_loan_balance = $total_unpaid_principal + $total_unpaid_interest + $total_unpaid_risk;
            $loan = Loan::find($loan_id);
            $loan->loan_balance      = $total_loan_balance;
            $loan->balance_principal = $total_unpaid_principal;
            $loan->balance_interest  = $total_unpaid_interest;
            $loan->balance_risk      = $total_unpaid_risk;
            $loan->decrement('loan_in',$acc->payment_per_month);
            $loan->decrement('paid_principal',$acc->principal);
            $loan->decrement('paid_interest',$acc->interest_per_month);
            $loan->decrement('paid_risk',$acc->risk_per_month);
            $loan->decrement('total_penalty',$acc->penalty);
            $loan->loan_status_id = 2;
            $loan->completed_date = null;
            $loan->update();
            AccReceivables::where('loan_id',$loan_id)->where('payment_status_id',5)->update(['payment_status_id' => 2]);


            BackPayment::where('loan_id',$loan_id)->update(['status'=>2]);
            AccReceivables::where('id',$id)->delete();
            AccReceivableDetails::where('acc_id',$id)->delete();
            $newBack=  BackPayment::where('loan_id',$loan_id)->first();

            $user = User::find(Auth::user()->id);
            $client = Client::find($acc->client_id);
            $subject = "ត្រឡប់ប្រតិបត្តិការបង់ប្រាក់របស់អតិថិជន $client->name ដោយ $user->name.";
            $subject_type = get_class($newBack);
            $subject_id = $newBack->id;
            $causer_type = get_class($user);
            $causer_id = Auth::user()->id;
            $branch = Auth::user()->branch_id;
            $log_name = 'Loan Model';
            LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
            DB::commit();
            $res = [
                'status' => 1,
                'message'=> 'ត្រឡប់ប្រតិបត្តិការបានដោយជោគជ័យ',
                // 'data'   => ShowPaymentResource::collection($data)
            ];
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'ត្រឡប់ប្រតិបត្តិការមិនបានជោគជ័យ',
                'data'    => $e->getMessage(),
            ];
        }
        return response()->json($res,200);

    }
}
