<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Models\Company;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Resources\CompanyResource;
use Exception;

class CompanyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getCompany(){
       return Company::get()
        ->map(function($value){
            return [
                'id'        => $value->id,
                'value'     => $value->id,
                'name_en'      => $value->name_en
            ];
        });
    }
    public function index(Request $request)
    {
        return Company::first();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $com = Company::find($request->id);

        if($com){
            $res = [
                'status' => 1,
                'message'=> 'Get Company success',
                'data'   => new CompanyResource($com)
            ];
        }else{
            $res = [
                'status'  => 0,
                'message' => 'Get Company not found',
                'data'    => []
            ];
        }
        return response()->json($res,200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'code'=> "required|min:3|max:8|unique:companies,code,{$request->id},id,deleted_at,NULL",
            'name_kh' => 'nullable|required_if:name_en,null|max:100',
            'name_en' => 'nullable|required_if:name_kh,null|max:100',
            'contact_number' => 'required'
        ]);
        try{
            DB::beginTransaction();
            $com = Company::updateOrCreate(['id' => $this->getCompanyRequest($request)['id']],$this->getCompanyRequest($request));

            DB::commit();
            $res = [
                'status' => 1,
                'message'=> $com->wasRecentlyCreated?'Create Company success':'Update Company success',
                'data'   => new CompanyResource($com)
            ];
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Create Company not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);

    }
    public function getCompanyRequest($request)
    {
        $company = Company::find($request->id);
        $image = Helper::Base64Upload($request->logo, 'uploads/companies/',  $company->logo??'');
        $data = [
            'id'        => $request->id,
            'code'      => $request->code,
            'name_kh' => $request->name_kh ?? $request->name_en,
            'name_en' => $request->name_en ?? $request->name_kh,
            'contact_number' => $request->contact_number,
            'email' => $request->email,
            'website' => $request->website,
            'address' => $request->address,
            'logo'     => $image??'uploads/companies/default.png',
            'status' => $request->status??1
        ];
        return $data;
    }

}
