<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Models\Village;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Client;
use App\Models\Commune;
use App\Models\District;
use App\Helpers\LogActivity;
use App\Models\Accounting\ChartOfAccount;
use App\Models\Collateral;
use App\Models\Currency;
use App\Models\LoanStatus;
use App\Models\PaymentMethod;
use App\Models\Province;
use App\Models\User;
use Collator;
use Illuminate\Support\Facades\Auth;

class ComponentController extends Controller
{
    public function autoCompleteAddress(Request $request)
    {
        return Village::search($request->searchText)->take(10)->pluck('address_km')->toArray();
    }

    public function getPaymentMethod()
    {
        return PaymentMethod::all()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'title' => $value->title
            ];
        });
    }
    public function getProvince(Request $request)
    {
        $data = Province::all()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'full_name_km' => $value->full_name_km
            ];
        });
        return response()->json($data);
    }
    public function getDistrict(Request $request)
    {
        return District::where('province_id', $request->province_id)->get()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'full_name_km' => $value->full_name_km
            ];
        });
    }
    public function getCommune(Request $request)
    {
        return Commune::where('district_id', $request->district_id)->get()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'full_name_km' => $value->full_name_km
            ];
        });
    }
    public function getVillage(Request $request)
    {
        return Village::where('commune_id', $request->commune_id)->get()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'full_name_km' => $value->full_name_km
            ];
        });
    }
    public function getClient(Request $request)
    {
        return Client::whereIn('branch_id',Helper::byBranch())->where('status',1)->orderby('id','desc')->get()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'name' => $value->name
            ];
        });
    }
    public function getCO(Request $request)
    {
        return User::whereIn('branch_id',Helper::byBranch())->where('status',1)->where('type',2)->whereIn('id',Helper::group())->get()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'name' => $value->name
            ];
        });
    }
    public function getLoanStatus(Request $request)
    {
        return LoanStatus::where('id','<',4)->get()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'title' => $value->title
            ];
        });
    }
    public function getCategory(Request $request)
    {
        return Category::get()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'title' => $value->title
            ];
        });
    }
    public function getUser(Request $request)
    {
        return User::whereIn('branch_id',Helper::byBranch())->where('type',1)->where('status',1)->get()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'name' => $value->name
            ];
        });
    }
    public function getCollateral(Request $request)
    {
        return Collateral::get()->map(function($value){
            return [
                'id' => $value->id,
                'value' => $value->id,
                'title' => $value->title
            ];
        });
    }

    public function getDefaultCurrency(Request $request)
    {
        $data = Auth::user()->currency_id;
        return $data;
    }
}
