<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Currency;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CurrencyController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Currency List', ['only' => ['index']]);
        $this->middleware('permission:Currency Create', ['only' => ['store']]);
        $this->middleware('permission:Currency Edit', ['only' => ['store']]);
        $this->middleware('permission:Currency Delete', ['only' => ['destroy']]);
    }
    public function index(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Currency::paginate($per_page);
        return $data;
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $currency = Currency::find($request->id);
        if($currency){
            $res = [
                'status' => 1,
                'message'=> 'Create currency success',
                'data'   => $currency
            ];
        }else{
            $res = [
                'status'  => 0,
                'message' => 'Create currency not found',
                'data'    => []
            ];
        }
        return response()->json($res,200);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'currency_en' => 'nullable|required',
            'currency_km' => 'nullable|required',
            'symbol' => 'nullable|required'
        ]);
        try{
            DB::beginTransaction();
            $com = Currency::updateOrCreate(['id' => $this->getCurrencyRequest($request)['id']],$this->getCurrencyRequest($request));

            DB::commit();
            $res = [
                'status' => 1,
                'message'=> $com->wasRecentlyCreated?'Create Currency success':'Update Currency success',
                'data'   => $com
            ];
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Create Currency not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        DB::beginTransaction();
        try {

            $branch = Currency::find($id);
            $branch->delete();
            $res = [
                'status' => 1,
                'message'=> 'Deleted success',
                'data'   => $branch
            ];
            DB::commit();
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Deleted not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);
    }
    public function getCurrencyRequest($request)
    {
        $data = [
            'id'        => $request->id,
            'currency_en' => $request->currency_en,
            'currency_km' => $request->currency_km,
            'symbol' => $request->symbol
        ];
        return $data;
    }
}
