<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\LogActivity;
use App\Http\Controllers\Controller;
use App\Models\Holiday;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HolidayController extends Controller
{
    function __construct()
    {
         $this->middleware('permission:Holiday List|Holiday Create|Holiday Edit|Holiday Delete', ['only' => ['index','store']]);
         $this->middleware('permission:Holiday Create', ['only' => ['create','store']]);
         $this->middleware('permission:Holiday Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:Holiday Delete', ['only' => ['destroy']]);
    }
    public function comHoliday(Request $request)
    {
        $data = Holiday::orderBy('date','asc')->get();
        return $data;
    }
    public function index(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Holiday::orderBy('id','DESC')->paginate($per_page);
        return $data;
    }
    public function create(Request $request)
    {
        $cat = Holiday::find($request->id);

        if($cat){
            $res = [
                'status' => 1,
                'message'=> 'Create holiday success',
                'data'   => $cat
            ];
        }else{
            $res = [
                'status'  => 0,
                'message' => 'Create holiday not found',
                'data'    => []
            ];
        }
        return response()->json($res,200);
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'nullable|required'
        ]);
        try{
            DB::beginTransaction();
            $com = Holiday::updateOrCreate(['id' => $this->getHolidayRequest($request)['id']],$this->getHolidayRequest($request));

            DB::commit();
            $res = [
                'status' => 1,
                'message'=> $com->wasRecentlyCreated?'Create Holiday success':'Update Holiday success',
                'data'   => $com
            ];
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Create Holiday not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);
    }

    public function destroy($id)
    {
        DB::beginTransaction();
        try {

            $cat = Holiday::find($id);
            $cat->delete();
            $res = [
                'status' => 1,
                'message'=> 'Deleted success',
                'data'   => $cat
            ];
            DB::commit();
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Deleted not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);
    }
    public function getHolidayRequest($request)
    {
        $data = [
            'id'        => $request->id,
            'title' => $request->title,
            'date' => $request->date==null?null:date('Y-m-d',strtotime($request->date)),
            'year' => $request->year==null?null:date('Y',strtotime($request->year))
        ];
        return $data;
    }
}
