<?php

namespace App\Http\Controllers\Admin;

use Exception;
use Carbon\Carbon;
use App\Models\Loan;
use App\Models\User;
use App\Models\Client;
use App\Models\Saving;
use App\Helpers\Helper;
use App\Models\Currency;
use App\Models\Guarantor;
use App\Models\Reschedule;
use App\Helpers\LogActivity;
use Illuminate\Http\Request;
use App\Models\AccReceivables;
use App\Models\CollateralDetail;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Resources\LoanResource;
use App\Http\Resources\UserResource;
use App\Models\AccReceivableDetails;
use Illuminate\Support\Facades\Auth;
use App\Http\Resources\ClientResource;
use App\Http\Resources\OverdueResource;
use App\Http\Resources\GuarantorResource;
use App\Http\Resources\ShowPaymentResource;
use App\Http\Resources\CollateralDetailResource;

class LoanController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Loan List', ['only' => ['index']]);
        $this->middleware('permission:Loan Create', ['only' => ['store','create','storeReschedule']]);
        $this->middleware('permission:Loan Edit', ['only' => ['edit','create','storeReschedule']]);
        $this->middleware('permission:Loan Delete', ['only' => ['destroy']]);
        $this->middleware('permission:Loan Approve', ['only' => ['update']]);
    }
    public function index(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Loan::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            $query->where('loan_status_id','>',1);
            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->term_type==[])
            {
                $query->where('term_type',$request->term_type);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            $query->where('client_type',$request->client_type);
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
            if(!$request->loan_status_id ==[]){
                $query->whereIn('loan_status_id',$request->loan_status_id);
            }
            if(!$request->loan_code ==''){
                $query->where('loan_code', 'LIKE', '%'.$request->loan_code.'%');
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->orderBy('id','DESC')
        ->paginate($per_page);
        return LoanResource::collection($data);
    }
    public function getListApprove(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Loan::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            $query->where('loan_status_id',1);
            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
            if(!$request->loan_status_id ==[]){
                $query->whereIn('loan_status_id',$request->loan_status_id);
            }
            if(!$request->loan_code ==''){
                $query->where('loan_code', 'LIKE', '%'.$request->loan_code.'%');
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->orderBy('id','DESC')
        ->paginate($per_page);
        return LoanResource::collection($data);
    }
    public function getLoanPayment(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Loan::whereHas('client', function ($query) use ($request) {
            if(!$request->loan_code ==''){
                $query->where('loans.loan_code', 'LIKE', '%'.$request->loan_code.'%');
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            $query->where('loan_status_id',2);
        })
        ->orderBy('id','DESC')
        ->paginate($per_page);
        return LoanResource::collection($data);
    }
    public function OverdueReport(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = AccReceivables::select(
                "acc_receivables.*"
                ,DB::raw('Max(payment_date) as max_payment'))
            ->where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('loan', function ($query) use ($request) {
            $query->where('loan_status_id',2);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->groupBy('loan_id')
        ->having('max_payment','<',date('Y-m-d'));
        if($request->per_page=="ALL")
        {
            $test = OverdueResource::collection($data->get());
        }
        else
        {
            $test = OverdueResource::collection($data->paginate($per_page));
        }
        return $test;
    }
    public function create(Request $request)
    {
        $currency_id = Auth::user()->currency_id;
        $loan = Loan::find($request->id);
        if($loan){
            $res = [
                'status' => 1,
                'currency_id' => $currency_id,
                'message'=> 'Loan loan success',
                'data'   => new LoanResource($loan)
            ];
        }else{
            $res = [
                'status'  => 0,
                'currency_id' => $currency_id,
                'message' => 'Loan loan not found',
                'data'    => []
            ];
        }
        return response()->json($res,200);
    }
    public function store(Request $request)
    {
        // dd($request->all());
        $this->validate($request, [
            'loan_out' => 'required|numeric|gte:'.'1',
            'client_id' => 'required',
            'co_id' => 'required'
        ]);
        try{
            DB::beginTransaction();
            $loan = Loan::updateOrCreate(['id' => $this->getLoan($request)['id']],$this->getLoan($request));
            if($request->id!='')
            {
                $saving = Saving::where('loan_id',$request->id)->first();
                if($saving)
                {
                    $saving->percent = $request->saving;
                    $saving->amount = $request->total_saving;
                    $saving->branch_id = Auth::user()->branch_id;
                    $saving->currency_id = Helper::byCurrency();
                    if($request->saving>0||$request->total_saving>0)
                    {
                        $saving->update();
                    }
                }
                AccReceivables::where('loan_id',$request->id)->delete();
                $user = User::find(Auth::user()->id);
                $client = Client::find($loan->client_id);
                $subject = "កែប្រែកម្ចីអតិថិជន $client->name ទំហំទឹកប្រាក់ $request->loan_out ដោយ $user->name.";
                $subject_type = get_class($loan);
                $subject_id = $loan->id;
                $causer_type = get_class($user);
                $causer_id = Auth::user()->id;
                $branch = Auth::user()->branch_id;
                $log_name = 'Loan Model';
                LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
            }
            else
            {
                if($request->saving>0||$request->total_saving>0)
                {
                    Saving::create([
                        'client_id' => $request->client_id,
                        'co_id' => $request->co_id,
                        'loan_id' => $loan->id,
                        'percent' => $request->saving,
                        'amount' => $request->total_saving,
                        'branch_id' =>Auth::user()->branch_id,
                        'currency_id' =>Helper::byCurrency()
                    ]);
                }

                $user = User::find(Auth::user()->id);
                $client = Client::find($loan->client_id);
                $subject = "បង្កើតកម្ចីថ្មីអតិថិជន $client->name ទំហំទឹកប្រាក់ $request->loan_out ដោយ $user->name.";
                $subject_type = get_class($loan);
                $subject_id = $loan->id;
                $causer_type = get_class($user);
                $causer_id = Auth::user()->id;
                $branch = Auth::user()->branch_id;
                $log_name = 'Loan Model';
                LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
            }
            foreach($request->rows as $key => $value){
                $arr = array(
                    'loan_id' => $loan->id,
                    'client_id' => $request->client_id,
                    'co_id' => $request->co_id,
                    'branch_id' => Auth::user()->branch_id,
                    'currency_id'     => Helper::byCurrency(),
                    'num' => $key + 1,
                    'payment_date' => date('Y-m-d', strtotime($value['payment_date'])),
                    'received_date' => null,
                    'interest_per_month' => $value['interestPerMonth'],
                    'risk_per_month' => $value['riskPerMonth'],
                    'maintenance_per_month' => $value['maintenancePerMonth'],
                    'principal' => $value['principal'],
                    'loan_balance' => $value['loan_balance'],
                    'payment_per_month' => $value['payment_per_month'],
                    'unreceived' =>  $value['payment_per_month'],
                    'created_at' => new \DateTime(),
                    'payment_status_id' => $loan->loan_status_id==1?4:3 // Pending
                );
                AccReceivables::insert($arr);
            }
            foreach($request->AddRemoveRows as $key=>$ColDetail)
            {
                $detail_id = [];
                $detail_collate = [];
                $detail_collate[]=$ColDetail['collateral_id'];
                $detail_id[]=$ColDetail['id'];
                if($detail_collate[0]!=null)
                {
                    CollateralDetail::updateOrCreate(
                        [
                            'id' => $ColDetail['id']
                        ],
                        [
                            'loan_id' => $loan->id,
                            'client_id' => $loan->client_id,
                            'collateral_id' => $ColDetail['collateral_id'],
                            'number' => $ColDetail['number'],
                            'status' => $ColDetail['status'],
                            'deleted_at' => null
                    ]);
                }
            }
            CollateralDetail::whereNotIn('id',$detail_id)->where('loan_id',$loan->id)->update([
                'deleted_at' => Carbon::now()
            ]);
            DB::commit();
            $res = [
                'status' => 1,
                'message'=> $loan->wasRecentlyCreated?'Loan Client success':'Update Client success',
                'data'   => new LoanResource($loan)
            ];
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Loan Client not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);

    }

    public function update($id)
    {
        $loan = Loan::find($id);
        $loan->loan_status_id = 2;
        $loan->approved_by = Auth::user()->id;
        $loan->update();
        AccReceivables::where('loan_id',$id)->update(['payment_status_id'=>3]);
        $user = User::find(Auth::user()->id);
        $client = Client::find($loan->client_id);
        $subject = "អនុញ្ញាតចេញកម្ចីអោយអតិថិជន $client->name ទំហំទឹកប្រាក់ $loan->loan_out ដោយ $user->name.";
        $subject_type = get_class($loan);
        $subject_id = $loan->id;
        $causer_type = get_class($user);
        $causer_id = Auth::user()->id;
        $branch = Auth::user()->branch_id;
        $log_name = 'Loan Model';
        LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
        $res = [
            'status' => 1,
            'message'=> 'Approved Client success',
            'data'   => new LoanResource($loan),
        ];
        return response()->json($res,200);
    }

    public function getLoan($request)
    {
        $total_interest = 0;
        $total_risk = 0;
        $total_maintenance = 0;
        foreach($request->rows as $key => $value){
            $total_interest += ($value['interestPerMonth']);
            $total_risk += ($value['riskPerMonth']);
            $total_maintenance += ($value['maintenancePerMonth']);
        }
        $data = [
            'id'        => $request->id,
            'client_id' => $request->client_id,
            'loan_code' => $request->loan_code??Helper::codeLoanAuto(Loan::class, Helper::prefix(),6, 'loan_code'),
            'co_id' => $request->co_id,
            'branch_id' => Auth::user()->branch_id,
            'currency_id'     => Helper::byCurrency(),
            'installment_date' => $request->installment_date != null ? date('Y-m-d', strtotime($request->installment_date)) : date('Y-m-d'),
            'start_date' => $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : date('Y-m-d'),
            'loan_out' => $request->loan_out,
            'risk' => $request->risk!=null?$request->risk:0,
            'total_risk' => $total_risk,
            'interest' => $request->interest!=null?$request->interest:0,
            'total_interest' => $total_interest,
            'maintenance' => $request->maintenance!=null?$request->maintenance:0,
            'total_maintenance' => $total_maintenance,
            'service' => $request->service,
            'total_service' => $request->total_service,
            'saving' => $request->saving,
            'total_saving' => $request->total_saving,
            'service_collection' => $request->service_collection,
            'total_collection' => $request->total_collection,
            'period' => $request->period,
            'condition_pay' => $request->condition_pay,
            'loan_receive' =>$request->loan_out + $total_interest + $total_risk + $total_maintenance,
            'loan_balance' =>$request->loan_out + $total_interest + $total_risk + $total_maintenance,
            'balance_principal' =>$request->loan_out,
            'balance_interest' =>$total_interest,
            'balance_risk' =>$total_risk,
            'balance_maintenance' =>$total_maintenance,
            'term_type' => $request->term_type,
            'desc' => $request->desc,
            'reschedule_amount' => $request->principal_down!=null?$request->principal_down:0,
            'type_loan' => $request->type_loan,
            'loan_status_id' => $request->id?$request->loan_status_id:1
        ];
        return $data;
    }

    public function ShowPayment($id)
    {
        $data = AccReceivables::where('loan_id',$id)->orderBy('payment_date','asc')->get();
        // dd($data);
        $loan= Loan::find($id);
        $client = Client::find($loan->client_id);
        $co = User::find($loan->co_id);
        $countSchedule = Loan::where('client_id', $loan->client_id)->count();
        $currency = Currency::find($loan->currency_id);
        $count = $data->count();
        $count = ceil($count/2);
        return [
            'data' =>ShowPaymentResource::collection($data),
            'loan' =>new LoanResource($loan),
            'client' =>new ClientResource($client),
            'co' =>new UserResource($co),
            'countSchedule' =>$countSchedule,
            'countPay' =>$count,
            'currency' =>$currency
        ];
    }
    public function GetPayment($id)
    {
        $data = AccReceivables::where('loan_id',$id)->orderBy('payment_date','asc')->get();
        $loan = Loan::find($id);
        $client = Client::find($loan->client_id);

        return [
            'data' =>ShowPaymentResource::collection($data),
            'client' =>new ClientResource($client)
        ];
    }
    public function destroy($id)
    {
        DB::beginTransaction();
        try {

            $loan = Loan::find($id);
            $loan->delete();
            AccReceivables::where('loan_id',$id)->delete();
            $user = User::find(Auth::user()->id);
            $client = Client::find($loan->client_id);
            $subject = "លុបកម្ចីរបស់អតិថិជន $client->name ទំហំទឹកប្រាក់ $loan->loan_out ដោយ $user->name.";
            $subject_type = get_class($loan);
            $subject_id = $loan->id;
            $causer_type = get_class($user);
            $causer_id = Auth::user()->id;
            $branch = Auth::user()->branch_id;
            $log_name = 'Loan Model';
            LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
            $res = [
                'status' => 1,
                'message'=> 'Deleted success',
                'data'   => $loan
            ];
            DB::commit();
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Deleted not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);
    }
    public function getContractDay($id)
    {
        $loan= Loan::find($id);
        $client = Client::find($loan->client_id);
        $profile = Guarantor::where('client_id',$loan->client_id)->where('type',1)->first();
        $one = Guarantor::where('client_id',$loan->client_id)->where('type',2)->first();
        $two = Guarantor::where('client_id',$loan->client_id)->where('type',3)->first();
        $real_estate_one = CollateralDetail::where('loan_id',$id)->where('status_type',1)->first();
        $currency = Currency::find($loan->currency_id);
        return [
            'loan' => new LoanResource($loan),
            'client' => new ClientResource($client),
            'profile' => $profile?(new GuarantorResource($profile)):null,
            'one' =>    $one?(new GuarantorResource($one)):null,
            'two' => $two?(new GuarantorResource($two)):null,
            'real_estate_one' => $real_estate_one?(new CollateralDetailResource($real_estate_one)):null,
            'currency' =>$currency
        ];
    }

    public function storeReschedule(Request $request)
    {
        // try{
        //     DB::beginTransaction();
        $id = $request['id'];
        if($request->principal_add>0)
        {
            $lastnum = AccReceivables::where('loan_id',$request->id)->whereIn('payment_status_id',[1,2])->orderBy('id','desc')->first();
            AccReceivables::where('loan_id', $id)->where('payment_status_id',3)->delete();

            $request['id'] = null;
            $request['loan_code'] = null;
            $loan = Loan::updateOrCreate(['id' => $this->getLoan($request)['id']],$this->getLoan($request));
            $save = new AccReceivables();
            $save->loan_id = $id;
            $save->client_id = $request->client_id;
            $save->co_id = $request->co_id;
            $save->branch_id = Auth::user()->branch_id;
            $save->currency_id = Helper::byCurrency();
            $save->num = $lastnum==null?1:$lastnum->num+1;
            $save->payment_date = date('Y-m-d');
            $save->received_date = date('Y-m-d');
            $save->interest_per_month = 0;
            $save->risk_per_month = 0;
            $save->open_close = 2;
            $save->loan_balance =0;
            $save->principal =  $request->balance_principal;
            $save->payment_per_month =  $request->balance_principal;
            $save->received =    $request->balance_principal;
            $save->unreceived =  0;
            $save->created_at = new \DateTime();
            $save->payment_status_id = 8;
            $save->save();

            $detail = new AccReceivableDetails();
            $detail->loan_id = $id;
            $detail->client_id = $request->client_id;
            $detail->co_id = $request->co_id;
            $detail->branch_id = Auth::user()->branch_id;
            $detail->currency_id = Helper::byCurrency();
            $detail->acc_id = $save->id;
            $detail->received_date = date('Y-m-d');
            $detail->paid_principal =  $request->balance_principal;
            $detail->received =    $request->balance_principal;
            $detail->unreceived =  0;
            $detail->condition_payment = 8;
            $detail->save();
            foreach($request->rows as $key => $value){
                $arr = array(
                    'loan_id' => $loan->id,
                    'client_id' => $request->client_id,
                    'co_id' => $request->co_id,
                    'branch_id' => Auth::user()->branch_id,
                    'currency_id'     => Helper::byCurrency(),
                    'num' => $key + 1,
                    'payment_date' => date('Y-m-d', strtotime($value['payment_date'])),
                    'received_date' => null,
                    'interest_per_month' => $value['interestPerMonth'],
                    'risk_per_month' => $value['riskPerMonth'],
                    'principal' => $value['principal'],
                    'loan_balance' => $value['loan_balance'],
                    'payment_per_month' => $value['payment_per_month'],
                    'unreceived' =>  $value['payment_per_month'],
                    'created_at' => new \DateTime(),
                    'payment_status_id' => $loan->loan_status_id==1?4:3 // Pending
                );
                AccReceivables::insert($arr);
            }
            foreach($request->AddRemoveRows as $key=>$ColDetail)
            {

                if($ColDetail['id']!=null)
                {
                    CollateralDetail::where('loan_id', $id)->update([
                        'status' =>2,
                    ]);

                    $dataCo = new CollateralDetail();
                    $dataCo->loan_id = $loan->id;
                    $dataCo->client_id = $loan->client_id;
                    $dataCo->collateral_id = $ColDetail['collateral_id'];
                    $dataCo->number = $ColDetail['number'];
                    $dataCo->status = $ColDetail['status'];
                    $dataCo->deleted_at = null;
                    $dataCo->save();
                }

            }


            $reschedule = New Reschedule();
            $reschedule->loan_id = $id;
            $reschedule->client_id = $request->client_id;
            $reschedule->co_id = $request->co_id;
            $reschedule->reschedule_service = $request->re_service;
            $reschedule->reschedule_total = $request->total_re;
            $reschedule->service = $request->service;
            $reschedule->service_total = $request->total_service;
            $reschedule->date = date('Y-m-d');
            $reschedule->branch_id = Auth::user()->branch_id;
            $reschedule->currency_id = Auth::user()->currency_id;
            $reschedule->status = 3;
            $reschedule->amount = $request->principal_add;
            $reschedule->save();

            $updateLoan = Loan::find($id);
            $updateLoan->loan_status_id = 3;
            $updateLoan->completed_date = $request->installment_date;
            $updateLoan->balance_principal = 0;
            $updateLoan->balance_interest = 0;
            $updateLoan->balance_risk = 0;
            $updateLoan->balance_maintenance = 0;
            $updateLoan->loan_balance = 0;
            $updateLoan->increment('loan_in', $request->principal_add);
            $updateLoan->increment('paid_principal', $request->principal_add);
            $updateLoan->update();

        }else{
            $loan = Loan::updateOrCreate(['id' => $this->getLoan($request)['id']],$this->getLoan($request));
            AccReceivables::where('loan_id',$request->id)->where('payment_status_id',3)->delete();
            $user = User::find(Auth::user()->id);
            $client = Client::find($loan->client_id);
            $subject = "រៀបចំតារាងកម្ចីអតិថិជន $client->name ទំហំទឹកប្រាក់ $request->loan_out ដោយ $user->name.";
            $subject_type = get_class($loan);
            $subject_id = $loan->id;
            $causer_type = get_class($user);
            $causer_id = Auth::user()->id;
            $branch = Auth::user()->branch_id;
            $log_name = 'Loan Model';
            LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
            $test = AccReceivables::where('loan_id',$request->id)->orderBy('id','desc')->first();

            $save = new AccReceivables();
            $save->loan_id = $request->id;
            $save->client_id = $request->client_id;
            $save->co_id = $request->co_id;
            $save->branch_id = Auth::user()->branch_id;
            $save->currency_id = Helper::byCurrency();
            $save->num = $test==null?1:$test->num+1;
            $save->payment_date = date('Y-m-d');
            $save->received_date = date('Y-m-d');
            $save->interest_per_month = $request->penalty_interest;
            $save->risk_per_month = 0;
            $save->open_close = 2;
            $save->loan_balance = $request->amount_principal;
            if($request->principal_down>0)
            {
                $save->principal = $request->principal_down;
                $save->payment_per_month = $request->principal_down+$request->penalty_interest;
                $save->received =   $request->principal_down + $request->penalty_interest;
            }else if($request->principal_up>0)
            {
                $save->principal = $request->principal_up;
                $save->payment_per_month = $request->principal_up+$request->penalty_interest;
                $save->received =   $request->principal_up+$request->penalty_interest;
            }
            else if($request->principal_add>0)
            {
                $save->principal = $request->balance_principal;
                $save->payment_per_month = $request->balance_principal;
                $save->received =   $request->balance_principal;
            }
            $save->unreceived =  0;
            $save->created_at = new \DateTime();
            $save->payment_status_id = 9;
            if($request->principal_down>0 || $request->principal_add>0)
            {
                $save->save();
            }

            $detail = new AccReceivableDetails();
            $detail->loan_id = $request->id;
            $detail->client_id = $request->client_id;
            $detail->co_id = $request->co_id;
            $detail->branch_id = Auth::user()->branch_id;
            $detail->currency_id = Helper::byCurrency();
            $detail->acc_id = $save->id;
            $detail->paid_interest =$request->penalty_interest;
            $detail->received_date = date('Y-m-d');
            if($request->principal_down>0)
            {
                $detail->paid_principal = $request->principal_down;
                $detail->received =   $request->principal_down+$request->penalty_interest;
            }else if($request->principal_up>0)
            {
                $detail->paid_principal = $request->principal_up;
                $detail->received =   $request->principal_up+$request->penalty_interest;
            }
            else if($request->principal_add>0)
            {
                $detail->paid_principal = $request->balance_principal;
                $detail->received =   $request->balance_principal;
            }
            $detail->unreceived =  0;
            $detail->condition_payment = 9;
            if($request->principal_down>0 || $request->principal_add>0)
            {
                $detail->save();
            }
            foreach($request->rows as $key => $value){
                $arr = array(
                    'loan_id' => $loan->id,
                    'client_id' => $request->client_id,
                    'co_id' => $request->co_id,
                    'branch_id' => Auth::user()->branch_id,
                    'currency_id'     => Helper::byCurrency(),
                    'num' => $key + 1,
                    'payment_date' => date('Y-m-d', strtotime($value['payment_date'])),
                    'received_date' => null,
                    'interest_per_month' => $value['interestPerMonth'],
                    'risk_per_month' => $value['riskPerMonth'],
                    'principal' => $value['principal'],
                    'loan_balance' => $value['loan_balance'],
                    'payment_per_month' => $value['payment_per_month'],
                    'unreceived' =>  $value['payment_per_month'],
                    'created_at' => new \DateTime(),
                    'payment_status_id' => $loan->loan_status_id==1?4:3 // Pending
                );
                AccReceivables::insert($arr);
            }

            $reschedule = New Reschedule();
            $reschedule->loan_id = $request->id;
            $reschedule->client_id = $request->client_id;
            $reschedule->co_id = $request->co_id;
            $reschedule->reschedule_service = $request->re_service;
            $reschedule->reschedule_total = $request->total_re;
            $reschedule->penalty_interest = $request->penalty_interest;;
            $reschedule->date = date('Y-m-d');
            $reschedule->branch_id = Auth::user()->branch_id;
            $reschedule->currency_id = Auth::user()->currency_id;
            // $reschedule->status = $request->principal_down>0?1:2;
            if($request->principal_down>0)
            {
                $reschedule->status = 1;
                $reschedule->amount = $request->principal_down;
            }else if($request->principal_up>0)
            {
                $reschedule->status = 2;
                $reschedule->amount = $request->principal_up;
            }
            else if($request->principal_add>0)
            {
                $reschedule->status = 3;
                $reschedule->amount = $request->principal_add;
            }
            if($request->principal_down>0 || $request->principal_up>0 || $request->principal_add>0 )
            {
                $reschedule->save();
            }

            $update = AccReceivables::where('loan_id',$request->id)->where('payment_status_id',3)->orderBy('id','asc')->first();
            $update->open_close = 2;
            $update->update();
        }
            DB::commit();
            $res = [
                'status' => 1,
                'message'=> $loan->wasRecentlyCreated?'Loan Client success':'Update Client success',
                'data'   => new LoanResource($loan)
            ];
        // }catch(Exception $e){
        //     DB::rollBack();
            // $res = [
            //     'status'  => 0,
            //     'message' => 'Loan Client not success',
            //     'data'    => $e->getMessage(),
            // ];
        // }
        return response()->json($res,200);

    }
    public function MoveCo(Request $request)
    {
        $this->validate($request, [
            'from_co_id' => 'required',
            'to_co_id' => 'required'
        ]);
        DB::beginTransaction();
        try {

            if($request->loan_id=='')
            {
                Loan::where('co_id',$request->from_co_id)->update([
                    'co_id' => $request->to_co_id
                ]);

                AccReceivables::where('co_id',$request->from_co_id)->update([
                    'co_id' => $request->to_co_id
                ]);
                AccReceivableDetails::where('co_id',$request->from_co_id)->update([
                    'co_id' => $request->to_co_id
                ]);
            }
            else
            {
                Loan::where('co_id',$request->from_co_id)->where('id',$request->loan_id)->update([
                    'co_id' => $request->to_co_id
                ]);
                AccReceivables::where('co_id',$request->from_co_id)->where('loan_id',$request->loan_id)->update([
                    'co_id' => $request->to_co_id
                ]);
                AccReceivableDetails::where('co_id',$request->from_co_id)->where('loan_id',$request->loan_id)->update([
                    'co_id' => $request->to_co_id
                ]);
            }
            $user = User::find(Auth::user()->id);
            $from = User::find($request->from_co_id);
            $to = User::find($request->to_co_id);
            $subject = "ប្ដូរពីមន្រ្តីឥណទាន  $from->name ទៅមន្រ្តីឥណទាន $to->name ដោយ $user->name.";
            $subject_type = get_class($from);
            $subject_id = $from->id;
            $causer_type = get_class($user);
            $causer_id = Auth::user()->id;
            $branch = Auth::user()->branch_id;
            $log_name = 'Loan Model';
            LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
            $res = [
                'status' => 1,
                'message'=> 'Move success',
                'data'   => $user
            ];
            DB::commit();
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Move not success',
                'data'    => $e->getMessage()
            ];
        }
        return response()->json($res,200);
    }
    public function moveToWriteOff($id)
    {
        $loan = Loan::find($id);
        $loan->client_type = 2;
        $loan->update();
        $user = User::find(Auth::user()->id);
        $client = Client::find($loan->client_id);
        $subject ="អតិថិជន $client->name បានផា្លស់ប្ដូរទៅអតិថិជនខូច ដោយ $user->name.";
        $subject_type = get_class($loan);
        $subject_id = $loan->id;
        $causer_type = get_class($user);
        $causer_id = Auth::user()->id;
        $branch = Auth::user()->branch_id;
        $log_name = 'Loan Model';
        LogActivity::addToLog($subject,$subject_type,$subject_id,$causer_type,$causer_id,$branch,$log_name);
        $res = [
            'status' => 1,
            'message'=> 'Client Move to Write Off success',
            'data'   => new LoanResource($loan),
        ];
        return response()->json($res,200);
    }

}
