<?php

namespace App\Http\Controllers\Admin;

use App\Exports\ExportBorrow;
use App\Exports\ExportCo;
use App\Exports\ExportCollected;
use App\Exports\ExportCollection;
use App\Exports\ExportCompleted;
use App\Exports\ExportDaily;
use App\Exports\ExportLate;
use App\Exports\ExportLoan;
use App\Exports\ExportSummaryCo;
use App\Helpers\CustomDateFilter;
use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\CollectedResource;
use App\Http\Resources\LateResource;
use App\Http\Resources\LoanResource;
use App\Http\Resources\ShowPaymentResource;
use App\Http\Resources\SummaryResource;
use App\Models\AccReceivableDetails;
use App\Models\AccReceivables;
use App\Models\Loan;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use Carbon\Carbon;

class ReportController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Co Report', ['only' => ['CoReport']]);
        $this->middleware('permission:Daily Report', ['only' => ['DailyReport']]);
        $this->middleware('permission:Late Report', ['only' => ['LateReport']]);
        $this->middleware('permission:Collection Report', ['only' => ['CollectionReport']]);
        $this->middleware('permission:Collected Report', ['only' => ['CollectedReport']]);
        $this->middleware('permission:Completed Report', ['only' => ['CompletedReport']]);
        $this->middleware('permission:Borrow Report', ['only' => ['BorrowedReport']]);
        $this->middleware('permission:Summary Co Report', ['only' => ['SummaryCoReport']]);
    }
    public function CoReport(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Loan::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
            if(!$request->loan_status_id ==[]){
                $query->whereIn('loan_status_id',$request->loan_status_id);
            }
            else{
                $query->whereIn('loan_status_id',[2]);
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        });
        if($request->per_page=="ALL")
        {
            $test = LoanResource::collection($data->get());
        }
        else
        {
            $test = LoanResource::collection($data->paginate($per_page));
        }
        return $test;
    }
    public function ExportCo(Request $request){
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Loan::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->loan_status_id ==[]){
                $query->whereIn('loan_status_id',$request->loan_status_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
            if(!$request->loan_status_id ==[]){
                $query->whereIn('loan_status_id',$request->loan_status_id);
            }
            else{
                $query->whereIn('loan_status_id',[2]);
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        });
        if($request->per_page=="ALL")
        {
            $test = LoanResource::collection($data->get());
        }
        else
        {
            $test = LoanResource::collection($data->paginate($per_page));
        }
        $json_encode_lead = json_encode($test);
        $json_decode_lead = json_decode($json_encode_lead);
        return Excel::download(new ExportCo($json_decode_lead),'ExportCo.xlsx');
    }
    public function DailyReport(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = AccReceivables::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('payment_status_id',[2,3]);
            $query->whereIn('co_id',Helper::group());
            $query->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),date('Y-m-d'));
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        });
        if($request->per_page=="ALL")
        {
            $test = ShowPaymentResource::collection($data->get());
        }
        else
        {
            $test = ShowPaymentResource::collection($data->paginate($per_page));
        }
        return $test;
    }
    public function ExportDaily(Request $request){
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = AccReceivables::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('payment_status_id',[2,3]);
            $query->whereIn('co_id',Helper::group());
            $query->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),date('Y-m-d'));
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        });
        if($request->per_page=="ALL")
        {
            $test = ShowPaymentResource::collection($data->get());
        }
        else
        {
            $test = ShowPaymentResource::collection($data->paginate($per_page));
        }
        $json_encode_lead = json_encode($test);
        $json_decode_lead = json_decode($json_encode_lead);
        return Excel::download(new ExportDaily($json_decode_lead),'ExportDaily.xlsx');
    }
    public function LateReport(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = AccReceivables::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            $query->whereIn('payment_status_id',[2,3]);
            $query->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<',date('Y-m-d'));
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->whereHas('co', function ($query) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) {
            $query->where('status',1);
        })
        ->orderBy('payment_date','ASC')
        ->groupBy('loan_id')
        ->get()
        ->map(function($qq) use ($request){
            $now = Carbon::now();
            $end = Carbon::parse($qq->date_late);
            $total_late = $now->diff($end)->days;
            return [
                'loan_id'=>$qq->loan_id,
                'qty'=>$total_late
            ];
        });

        $loan_id = [];
        foreach($data as $v){
            if($request->late_date==1&&($v['qty']>0&&$v['qty']<15)){
                $loan_id[]= $v['loan_id'];
            }
            else if($request->late_date==2&&($v['qty']>14&&$v['qty']<=30)){
                $loan_id[]= $v['loan_id'];
            }
            else if($request->late_date==3 && $v['qty']>30 && $v['qty']<=60){
                $loan_id[]= $v['loan_id'];
            }
            else if($request->late_date==[]){
                $loan_id[]= $v['loan_id'];
            }
        }
        $data_new = AccReceivables::whereIn('loan_id', $loan_id)->groupBy('loan_id');

        if($request->per_page=="ALL")
        {
            $test = LateResource::collection($data_new->get());
        }
        else
        {
            $test = LateResource::collection($data_new->paginate($per_page));
        }
        return $test;
    }
    public function ExportLate(Request $request){
        $per_page = $request->per_page == null?25: $request->per_page;

        $data = AccReceivables::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            $query->whereIn('payment_status_id',[2,3]);
            $query->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<',date('Y-m-d'));
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->orderBy('payment_date','ASC')
        ->groupBy('loan_id')
        ->get()
        ->map(function($qq) use ($request){
            $now = Carbon::now();
            $end = Carbon::parse($qq->date_late);
            $total_late = $now->diff($end)->days;
            return [
                'loan_id'=>$qq->loan_id,
                'qty'=>$total_late,
            ];
        });

        $loan_id = [];
        foreach($data as $v){
            if($request->late_date==1&&($v['qty']>0&&$v['qty']<15)){
                $loan_id[]= $v['loan_id'];
            }
            else if($request->late_date==2&&($v['qty']>14&&$v['qty']<=30)){
                $loan_id[]= $v['loan_id'];
            }
            else if($request->late_date==3 && $v['qty']>30 && $v['qty']<=60){
                $loan_id[]= $v['loan_id'];
            }
            else if($request->late_date==[]){
                $loan_id[]= $v['loan_id'];
            }
        }
        $data_new = AccReceivables::whereIn('loan_id', $loan_id)->groupBy('loan_id');

        if($request->per_page=="ALL")
        {
            $test = LateResource::collection($data_new->get());
        }
        else
        {
            $test = LateResource::collection($data_new->paginate($per_page));
        }
        $json_encode_lead = json_encode($test);
        $json_decode_lead = json_decode($json_encode_lead);
        return Excel::download(new ExportLate($json_decode_lead),'ExportLate.xlsx');
    }

    public function ExportLoan(Request $request){
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Loan::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->where('loan_status_id','>',1);
            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->term_type==[])
            {
                $query->where('term_type',$request->term_type);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
            if(!$request->loan_status_id ==[]){
                $query->whereIn('loan_status_id',$request->loan_status_id);
            }
            if(!$request->loan_code ==''){
                $query->where('loan_code', 'LIKE', '%'.$request->loan_code.'%');
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->orderBy('id','DESC');
        if($request->per_page=="ALL")
        {
            $test = LoanResource::collection($data->get());
        }
        else
        {
            $test = LoanResource::collection($data->paginate($per_page));
        }

        $json_encode_lead = json_encode($test);
        $json_decode_lead = json_decode($json_encode_lead);
        return Excel::download(new ExportLoan($json_decode_lead),'ExportLoan.xlsx');
    }
    public function CollectionReport(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = AccReceivables::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            $query->whereIn('payment_status_id',[2,3]);
            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        });

        if($request->per_page=="ALL")
        {
            $test = ShowPaymentResource::collection($data->get());
        }
        else
        {
            $test = ShowPaymentResource::collection($data->paginate($per_page));
        }
        return $test;
    }
    public function ExportCollection(Request $request){
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = AccReceivables::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('payment_status_id',[2,3]);
            $query->whereIn('co_id',Helper::group());

            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        });
        if($request->per_page=="ALL")
        {
            $test = ShowPaymentResource::collection($data->get());
        }
        else
        {
            $test = ShowPaymentResource::collection($data->paginate($per_page));
        }

        $json_encode_lead = json_encode($test);
        $json_decode_lead = json_decode($json_encode_lead);
        return Excel::download(new ExportCollection($json_decode_lead),'ExportCollection.xlsx');
    }
    public function CollectedReport(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = AccReceivableDetails::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        });
        if($request->per_page=="ALL")
        {
            $test = CollectedResource::collection($data->get());
        }
        else
        {
            $test = CollectedResource::collection($data->paginate($per_page));
        }
        return $test;
    }
    public function ExportCollected(Request $request){
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = AccReceivableDetails::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());

            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        });
        if($request->per_page=="ALL")
        {
            $test = CollectedResource::collection($data->get());
        }
        else
        {
            $test = CollectedResource::collection($data->paginate($per_page));
        }
        $json_encode_lead = json_encode($test);
        $json_decode_lead = json_decode($json_encode_lead);
        return Excel::download(new ExportCollected($json_decode_lead),'ExportCollected.xlsx');
    }
    public function CompletedReport(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Loan::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            $query->where('loan_status_id',3);
            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(completed_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        });
        if($request->per_page=="ALL")
        {
            $test = LoanResource::collection($data->get());
        }
        else
        {
            $test = LoanResource::collection($data->paginate($per_page));
        }
        return $test;
    }
    public function ExportCompleted(Request $request){
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Loan::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            $query->where('loan_status_id',3);
            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        });
        if($request->per_page=="ALL")
        {
            $test = LoanResource::collection($data->get());
        }
        else
        {
            $test = LoanResource::collection($data->paginate($per_page));
        }
        $json_encode_lead = json_encode($test);
        $json_decode_lead = json_decode($json_encode_lead);
        return Excel::download(new ExportCompleted($json_decode_lead),'ExportCompleted.xlsx');
    }
    public function BorrowedReport(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Loan::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            $query->where('loan_status_id',2);
            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        });
        if($request->per_page=="ALL")
        {
            $test = LoanResource::collection($data->get());
        }
        else
        {
            $test = LoanResource::collection($data->paginate($per_page));
        }
        return $test;
    }
    public function ExportBorrow(Request $request){
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Loan::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereIn('co_id',Helper::group());
            $query->where('loan_status_id',2);
            if(!$request->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[])
            {
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->whereHas('co', function ($query) use ($request) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) use ($request) {
            $query->where('status',1);
        });
        if($request->per_page=="ALL")
        {
            $test = LoanResource::collection($data->get());
        }
        else
        {
            $test = LoanResource::collection($data->paginate($per_page));
        }
        $json_encode_lead = json_encode($test);
        $json_decode_lead = json_decode($json_encode_lead);
        return Excel::download(new ExportBorrow($json_decode_lead),'ExportBorrow.xlsx');
    }
    public function SummaryCoReport(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = User::where('type',2)->whereIn('id',Helper::group())->where('status',1);
        if($request->per_page=="ALL")
        {
            $test = SummaryResource::collection($data->get());
        }
        else
        {
            $test = SummaryResource::collection($data->paginate($per_page));
        }
        return $test;
    }

    public function ExportSummaryCo(Request $request){
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = User::where('type',2)->whereIn('id',Helper::group())->where('status',1);
        if($request->per_page=="ALL")
        {
            $test = SummaryResource::collection($data->get());
        }
        else
        {
            $test = SummaryResource::collection($data->paginate($per_page));
        }
        $json_encode_lead = json_encode($test);
        $json_decode_lead = json_decode($json_encode_lead);
        return Excel::download(new ExportSummaryCo($json_decode_lead),'ExportSummaryCo.xlsx');
    }

    public function paymentNotClosingReport(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = AccReceivableDetails::where(function($query) use ($request){
            // $query->whereIn('co_id',Helper::group());
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->whereNull('closing_date');
            if(!$request->client_id ==[]) {
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[]) {
                $query->whereIn('co_id',$request->co_id);
            }
            if(!$request->status_approve==''){
                $query->where('status',$request->status_approve);
            }
            if(!$request->date ==[]) {
                $query->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), $request->date ?? CustomDateFilter::thisDay());
            }
        })
        ->orderby('received_date','desc')
        ->orderby('id','desc');

        if($request->per_page=="ALL" || $request->pagin == 'true') {
            return CollectedResource::collection($data->get());
        } else{
            return CollectedResource::collection($data->paginate($per_page));
        }
    }

    public function loanNotClosingReport(Request $request)
    {
        $per_page = $request->per_page == null?25: $request->per_page;
        $data = Loan::where(function($query) use ($request){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            // $query->whereIn('co_id',Helper::group());
            $query->where('loan_status_id',2);
            $query->whereNull('closing_date');
            if(!$request->date==[]){
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), $request->date);
            }
            if(!$request->client_id ==[]){
                $query->whereIn('client_id',$request->client_id);
            }
            if(!$request->co_id ==[]){
                $query->whereIn('co_id',$request->co_id);
            }
        })
        ->orderBy('id','desc');
        // return $data->paginate($per_page);
        if($request->per_page=="ALL" || $request->pagin == 'true'){
            return LoanResource::collection($data->get());
        } else {
            return LoanResource::collection($data->paginate($per_page));
        }
    }
}
