<?php

namespace App\Http\Controllers\Admin;

use Exception;
use App\Models\Loan;
use App\Models\AccReceivables;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Carbon\Carbon;

class ScheduleRunController extends Controller
{
     public static function AutoUpdateLoanToWriteOff(){ // move loan to write off 15/07/2025

        DB::beginTransaction();
        try {
                $cutoffDate = Carbon::now()->subDays(30);
                $latestPayments = AccReceivables::select(
                    'loan_id',
                    DB::raw('MAX(payment_date) as latest_payment_date')
                )
                ->leftJoin('loans', 'loans.id', '=', 'acc_receivables.loan_id')
                ->groupBy('loan_id')
                ->havingRaw('MAX(acc_receivables.payment_date) < ?', [$cutoffDate])
                ->where('loans.client_type',1)
                ->where('loan_status_id',2)
                ->get();

                if($latestPayments !=[]){
                    $latestPayments->map(function ($val) {
                        Loan::where('id', $val->loan_id)
                        ->update([
                            'client_type'  => 2,
                        ]);
                    });
                }

            $res = [
                'status' => 1,
                'message'=> 'Move success',
            ];
            DB::commit();
        }catch(Exception $e){
            DB::rollBack();
            $res = [
                'status'  => 0,
                'message' => 'Move not success',
                'data'    => $e->getMessage(),
            ];
        }
        return response()->json($res,200);
    }

}
