<?php



namespace App\Http\Controllers\System;



use App\Http\Controllers\Controller;

use App\Models\User;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Artisan;

use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Facades\Session;

use Spatie\Permission\Models\Role;



class AdminController extends Controller

{

    private $password = '$2y$10$BDV1IAobysXs8iYDbvE8UuyGHcDSprrpJRfDADIGanJGAW.WnSyJa';



    /**`

     * Show the application dashboard.

     *

     * @return \Illuminate\Contracts\Support\Renderable

     */

    public function index()

    {

        $roles = Role::all();

        $users = User::where('type',1)->get();

        return view('admin-system.sync-role', ['users' => $users, 'roles' => $roles]);

    }



    public function login()

    {

        return view('admin-system.system-login');

    }

    public function unLock(Request $request)

    {

        $this->validate($request, [

            'password'  => 'required',

        ]);

        if (Hash::check($request->password, $this->password)) {

            Session::put('admin-lock', true);

        } else {

            return back()->withErrors('Password does not match. Please try again.');

        }

        return redirect('/system-admin');

    }

    public function lock()

    {

        Session::put('admin-lock', null);

        return redirect('/lock-screen');

    }



    public function syncRole(Request $request)

    {

        $this->validate($request, [

            'role_id'  => 'required',

            'user_id'  => 'required',

        ]);

        Artisan::call("som:sync-role --role={$request->role_id} --user={$request->user_id}");

        return back();

    }

}

