<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return  [
            'name' => 'required',
            'gender' => 'required',
            'email' => 'required|string|regex:/(^[a-zA-Z]+[a-zA-Z0-9\\-@.]*$)/u|unique:users,email,' . request()->id,
            'password'  => isset(request()->id) ? 'nullable' : 'required|same:confirm_password',
            'confirm_password'  => isset(request()->id) ? 'nullable' : 'required|same:password',
            'role_id' => 'required',
        ];
    }
}
