<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class ChartOfAccountResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'type_of_acc_detail_id' => $this->type_of_acc_detail_id,
            'chart_code'    => $this->chart_code,
            'chart_name'    => $this->chart_name,
            'desc'          => $this->desc,
            'name'          => $this->typeAccDetails->name??'',
            'type_of_acc_id'=> $this->typeAccDetails->type_of_acc_id??'',
            'created_by'    => $this->createdBy->name??'',
            'created_at'    => $this->created_at,
            'updated_at'    => $this->updated_at,
        ];
    }
}
