<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class DepreciationDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'           => $this->id,
            'dep_id'       => $this->dep_id,
            'payment_date' => $this->payment_date,
            'paid_date'    => $this->paid_date,
            'amount'       => $this->amount,
            'paid'         => $this->paid,
            'unpaid'       => $this->unpaid,
            'loan_balance' => $this->loan_balance,
        ];
    }
}
