<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class DepreciationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'                => $this->id,
            'asset_id'          => $this->asset_id,
            'currency_id'          => $this->currency_id,
            'branch_id'          => $this->branch_id,
            'chart_asset'       => $this->chart_asset,
            'chart_expense'     => $this->chart_expense,
            'depreciation_date' => $this->depreciation_date,
            'period'            => $this->period,
            'total_amount'      => $this->total_amount,
            'total_paid'        => $this->total_paid,
            'balance'           => $this->balance,
            'desc'              => $this->desc,
            'asset_name'        => $this->assets->name??'',
            'acc_asset_name'    => $this->chartAsset->chart_name??'',
            'asset_code'        => $this->chartAsset->chart_code??'',
            'expense_name'      => $this->chartExpense->chart_name??'',
            'expense_code'      => $this->chartExpense->chart_code??'',
            'created_by'        => $this->createdBy->name??'',
            'created_at'        => $this->created_at,
            'updated_at'        => $this->updated_at,
            'details'           => DepreciationDetailResource::collection($this->depreciationDetail),
        ];
    }
}
