<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class JournalResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'                 => $this->id,
            'debit'              => $this->debit,
            'credit'             => $this->credit,
            'desc'               => $this->desc,
            'journal_date'       => $this->journal_date,
            'invoice_number'     => $this->invoice_number,
            'payment_model_id'   => $this->payment_model_id,
            'payment_model_type' => $this->payment_model_type,
            'parent_id'          => $this->parent_id,
            'chart_of_acc_id'    => $this->chart_of_acc_id,
            'created_by'         => $this->createdBy->name,
            'chart_name'         => $this->chartOfAcc->chart_name??'',
            'chart_code'         => $this->chartOfAcc->chart_code??'',
        ];
    }
}
