<?php

namespace App\Http\Resources;

use App\Models\Loan;
use Illuminate\Http\Resources\Json\JsonResource;

class ClientResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'        => $this->id,
            'code'      => $this->code,
            'branch_id'      => $this->branch_id,
            'name'      => $this->name,
            'name_en'      => $this->name_en,
            'gender'      => $this->gender,
            'phone'      => $this->phone,
            'type_document'      => $this->type_document,
            'id_card'      => $this->id_card,
            'issued_by'      => $this->issued_by,
            'relationship'      => $this->relationship,
            'date_of_birth'      => $this->date_of_birth,
            'place_of_birth'      => $this->place_of_birth,
            'create_card_date'      => $this->create_card_date,
            'expired_card_date'      => $this->expired_card_date,
            'institution'      => $this->institution,
            'position'      => $this->position,
            'work_place'      => $this->work_place,
            'address'      => $this->address,
            'created_at'=> $this->created_at,
            'updated_at'=> $this->updated_at,
            'province_id'=> $this->province_id,
            'district_id'=> $this->district_id,
            'commune_id'=> $this->commune_id,
            'village_id'=> $this->village_id,
            'province_kh'=> $this->province->name_km??'',
            'district_kh'=> $this->district->name_km??'',
            'commune_kh'=> $this->commune->name_km??'',
            'village_kh'=> $this->village->name_km??'',
            'status' => $this->status,
            'photo'      => $this->photo,
            'remark'      => $this->remark,
            'income'      => $this->income,
            'expense'      => $this->expense,
            'balance'      => $this->balance,
            'obj'      => Loan::where('client_id',$this->id)->whereIn('loan_status_id',[1,2,3])->count()

        ];

    }
}
