<?php

namespace App\Http\Resources;

use App\Models\AccReceivables;
use App\Models\User;
use Illuminate\Http\Resources\Json\JsonResource;

class CollateralDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $finish_date = AccReceivables::where('loan_id',$this->loan_id)->max('payment_date');
        $co_name = User::where('id',$this->loan->co_id)->first();
        return [
            'id'        => $this->id,
            'title'      => $this->collateral->title??'',
            'name'      => $this->client->name??'',
            'phone'      => $this->client->phone??'',
            'co_name'      => $co_name->name,
            'loan_code'      => $this->loan->loan_code??'',
            'installment_date'      => $this->loan->installment_date??'',
            'type_loan'      => $this->loan->type_loan??'',
            'interest'      => $this->loan->interest??0,
            'total_interest'      => $this->loan->total_interest??0,
            'loan_out'      => $this->loan->loan_out??0,
            'number'   => $this->number,
            'finish_date'   => $finish_date,
            'model_type'   => $this->model_type,
            'number_plate'   => $this->number_plate,
            'body_number'   => $this->body_number,
            'engine_number'   => $this->engine_number,
            'cylinder_size'   => $this->cylinder_size,
            'year'   => "$this->year",
            'date_made'   => $this->date_made,
            'price_market'   => $this->price_market,
            'price_urgent'   => $this->price_urgent,
            'color'   => $this->color,
            'degree'   => $this->degree,
            'head_land'   => $this->head_land,
            'size'   => $this->size,
            'issued_by'   => $this->issued_by,
            'location'   => $this->location,
            'status_type'   => $this->status_type,
            'status'   => $this->status,
            'north'   => $this->north,
            'west'   => $this->west,
            'south'   => $this->south,
            'east'   => $this->east

        ];
    }
}
