<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CollectedResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'        => $this->id,
            'acc_id'        => $this->acc_id,
            'client_name'      => $this->client->name??'',
            'client_code'      => $this->client->code??'',
            'client_phone'      => $this->client->phone??'',
            'client_id'      => $this->client_id,
            'co_name'      => $this->co->name,
            'loan_code'      => $this->loan->loan_code,
            'payment_status_id'      => $this->acc_receivable->payment_status_id,
            'received_date'      => $this->received_date,
            'paid_principal'      => $this->total_principal,
            'paid_interest'      => $this->total_interest,
            'paid_risk'      => $this->total_risk,
            'paid_maintenance'      => $this->total_maintenance,
            'received'      => $this->total_received,
            'unreceived'      => $this->total_unreceived,
            'paid_penalty'      => $this->total_penalty,
            'payment_method'      => $this->payment_method,
            'status'      => $this->status,
            'closing_date'      => $this->closing_date,
            'waiv_penalty'      => $this->waiv_penalty


        ];
    }
}
