<?php

namespace App\Http\Resources;

use App\Models\Group;
use Illuminate\Http\Resources\Json\JsonResource;

class GroupResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $detail = Group::select(
            'groups.id',
            'groups.user_id',
            'groups.co_id',
            'users.name',
        )
        ->leftjoin('users','users.id','groups.co_id')
        ->where('user_id', $this->user_id)
        ->where('groups.status',1)
        ->get();
        return [
            'id'        => $this->id,
            'user_id'   => $this->user_id,
            'name'      => $this->user->name,
            'detail'    => $detail,
            'status'    => $this->status
        ];
    }
}
