<?php

namespace App\Http\Resources;

use App\Repository\ClientLateRepository as cleintLateRe;
use Illuminate\Http\Resources\Json\JsonResource;

class LateResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $repo = new cleintLateRe();

        return [
            'id'                => $this->id,
            'client_name'       => $this->client->name,
            'client_phone'      => $this->client->phone,
            'village_km'        => $this->client->village->full_name_km??'',
            'client_id'         => $this->client_id,
            'co_name'           => $this->co->name,
            'loan_code'         => $this->loan->loan_code,
            'balance_principal' => $this->loan->balance_principal,

            // 'principal_late'    => $this->principal_late,
            // 'interest_late'     => $this->interest_late,
            // 'risk_late'         => $this->risk_late,
            // 'maintenance_late'  => $this->maintenance_late,
            // 'received_late'     => $this->received_late,
            // 'unreceived_late'   => $this->unreceived_late,
            'total_late'        => $this->total_late,
            'date_late'         => $this->date_late,
            // 'total_balance_principal'=> $this->total_balance_principals,

            'principal_late'      => $repo->getPrincipalLate($this->loan_id),
            'interest_late'       => $repo->getInterestLate($this->loan_id),
            'risk_late'           => $repo->getRisklate($this->loan_id),
            'maintenance_late'    => $repo->getMaintenancelate($this->loan_id),
            'received_late'       => $repo->getReceivedlate($this->loan_id),
            'unreceived_late'     => $repo->unReceivedlate($this->loan_id),
            'total_balance_principal'=> $repo->getBalancePrincipal()

        ];
    }
}
