<?php

namespace App\Http\Resources;

use App\Models\AccReceivables;
use App\Models\CollateralDetail;
use Illuminate\Http\Resources\Json\JsonResource;

class LoanResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $array = array(
            [
                'id' => '',
                'number' => '',
                'collateral_id' => '',
                'status' => 1,
            ]
        );
        return [
            'id'                => $this->id,
            'loan_code'         => $this->loan_code,
            'client_id'         => $this->client_id,
            'currency_id'       => $this->currency_id,
            'client_name'       => $this->client->name??'',
            'co_id'             => $this->co_id,
            'co_name'           => $this->co->name??'',

            'installment_date'  => $this->installment_date,
            'completed_date'    => $this->completed_date,
            'start_date'        => $this->start_date,
            'reschedule_amount' => $this->reschedule_amount,
            'loan_out'          => $this->loan_out,
            'risk'              => $this->risk,
            'total_risk'        => $this->total_risk,
            'interest'          => $this->interest,
            'total_interest'    => $this->total_interest,
            'maintenance'       => $this->maintenance,
            'total_maintenance' => $this->total_maintenance,
            'service'           => $this->service,
            'total_service'     => $this->total_service,
            'service_collection'=> $this->service_collection,
            'total_collection'  => $this->total_collection,
            'saving'            => $this->saving,
            'total_saving'      => $this->total_saving,
            'total_penalty'     => $this->total_penalty,
            'loan_receive'      => $this->loan_receive,
            'balance_principal' => $this->total_balance_principal,
            'balance_interest'  => $this->balance_interest,
            'balance_risk'      => $this->balance_risk,
            'loan_balance'      => $this->loan_balance,
            'paid_principal'    => $this->paid_principal,
            'paid_interest'     => $this->paid_interest,
            'paid_risk'         => $this->paid_risk,
            'paid_maintenance'  => $this->paid_maintenance,
            'loan_in'           => $this->loan_in,
            'period'            => $this->period,
            'loan_status_id'    => $this->loan_status_id,
            'loan_status'       => $this->loan_status->title,
            'color'             => $this->loan_status->color,
            'term_type'         => $this->term_type,
            'type_loan'         => $this->type_loan,
            'condition_pay'     => $this->condition_pay,
            'created_at'        => $this->created_at,
            'updated_at'        => $this->updated_at,
            'desc'              => $this->desc,
            'client_type'       => $this->client_type,

            'level'=> substr($this->loan_code,-2),
            'AddRemoveRows'=> CollateralDetail::where('loan_id',$this->id)->count()>0?CollateralDetail::where('loan_id',$this->id)->get():$array,
            'rows'=> [],
            'obj' => AccReceivables::where('loan_id',$this->id)->whereIn('payment_status_id',[1,2])->count(),
            'finish_date' => AccReceivables::where('loan_id',$this->id)->orderBy('payment_date', 'DESC')->first()->payment_date??''
        ];
    }
}
