<?php

namespace App\Http\Resources;

use App\Models\AccReceivables;
use App\Models\CollateralDetail;
use Illuminate\Http\Resources\Json\JsonResource;

class OverdueResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $array = array(
            [
                'id' => '',
                'number' => '',
                'collateral_id' => '',
                'status' => 1
            ]
        );
        return [
            'id'        => $this->loan->id,
            'loan_code'      => $this->loan->loan_code,
            'client_code'      => $this->client->code,
            'client_id'      => $this->client_id,
            'currency_id'      => $this->currency_id,
            'client_name'      => $this->client->name??'',
            'co_id'      => $this->co_id,
            'co_name'      => $this->co->name??'',
            'installment_date'  => $this->loan->installment_date,
            'start_date'  => $this->loan->start_date,
            'reschedule_amount'    => $this->loan->reschedule_amount,
            'loan_out'   => $this->loan->loan_out,
            'risk' => $this->loan->risk,
            'total_risk'     => $this->loan->total_risk,
            'interest'     => $this->loan->interest,
            'total_interest'     => $this->loan->total_interest,
            'service'     => $this->loan->service,
            'total_service'      => $this->loan->total_service,
            'service_collection' => $this->loan->service_collection,
            'total_collection'     => $this->loan->total_collection,
            'total_penalty'     => $this->loan->total_penalty,
            'loan_receive' => $this->loan->loan_receive,
            'balance_principal'      => $this->loan->balance_principal,
            'balance_interest'      => $this->loan->balance_interest,
            'balance_risk'      => $this->loan->balance_risk,
            'loan_balance'      => $this->loan->loan_balance,
            'paid_principal'      => $this->loan->paid_principal,
            'paid_interest'      => $this->loan->paid_interest,
            'paid_risk'      => $this->loan->paid_risk,
            'loan_in'      => $this->loan->loan_in,
            'period' => $this->loan->period,
            'loan_status_id' => $this->loan->loan_status_id,
            'loan_status'      => $this->loan->loan_status->title??'',
            'color'      => $this->loan->loan_status->color??'',
            'term_type'      => $this->loan->term_type,
            'condition_pay'      => $this->loan->condition_pay,
            'created_at'=> $this->loan->created_at,
            'updated_at'=> $this->loan->updated_at,
            'AddRemoveRows'=> CollateralDetail::where('loan_id',$this->loan->id)->count()>0?CollateralDetail::where('loan_id',$this->loan->id)->get():$array,
            'rows'=> [],
            'obj' => AccReceivables::where('loan_id',$this->loan->id)->whereIn('payment_status_id',[1,2])->count()

        ];
    }
}
