<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SavingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'        => $this->id,
            'client_name'           => $this->client->name,
            'client_code'           => $this->client->code,
            'village_kh'            => $this->client->village->name_km??'',
            'client_id'             => $this->client_id,
            'co_name'               => $this->co->name,
            'installment_date'      => $this->loan->installment_date,
            'loan_code'             => $this->loan->loan_code,
            'percent'               => $this->percent,
            'amount'                => $this->amount,
            'status_pay'            => $this->status_pay,
            'date_approved'         => $this->date_approved,
            'status'                => $this->status,
            'closing_date'          => $this->closing_date


        ];
    }
}
