<?php

namespace App\Http\Resources;

use App\Models\AccReceivables;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class ShowPaymentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $today = date('Y-m-d');
        $total_penalty = 0;
        $date = $this->received_date?$this->received_date:$today;
        $diff_date= Carbon::parse(date('Y-m-d', strtotime($date)));
        $payment_date= Carbon::parse(date('Y-m-d', strtotime($this->payment_date)));

        $interval =$payment_date->diff($diff_date);
        $total_late = intval($interval->format("%R%a"));
        if($total_late>0)
        {
            if($this->currency_id==1)
            {
                $total_penalty = round($total_late*2000,-2,PHP_ROUND_HALF_ODD);
            }
            else
            {
                $total_penalty = round($total_late*0.5,-2,PHP_ROUND_HALF_ODD);
            }
        }
        else{
            $total_penalty=0;
        }
        $penalty_payoff = $this->loan_balance*0.1;
        $balance_principal_new = $this->loan_balance+$this->payment_per_month;
        if($this->currency_id==1)
        {
            $penalty_payoff = round($penalty_payoff,-2,PHP_ROUND_HALF_ODD);
        }
        else
        {
            $penalty_payoff = round($penalty_payoff,2);
        }
        return [
            'id'                => $this->id,
            'loan_code'         => $this->loan->loan_code,
            'client_name'       => $this->client->name,
            'client_phone'      => $this->client->phone,
            'client_id'         => $this->client_id,
            'currency_id'       => $this->currency_id,
            'co_name'           => $this->co->name,
            'payment_date'      => $this->payment_date,
            'received_date'     => $this->received_date,
            'principal'         => $this->principal,
            'risk_per_month'    => $this->risk_per_month,
            'maintenance_per_month'   => $this->maintenance_per_month,
            'interest_per_month'      => $this->interest_per_month,
            'payment_per_month'       => $this->payment_per_month,
            'received'              => $this->received,
            'total_penalty'         => $this->received_date?$this->penalty:$total_penalty,
            'unreceived'            => $this->unreceived,
            'loan_balance'          => $this->loan_balance,
            'open_close'            => $this->open_close,
            'payment_method'        => $this->payment_method,
            'penalty_payoff'        => $penalty_payoff,
            'balance_principal_new' => $balance_principal_new,
            'payment_status_id'     => $this->payment_status_id?$this->payment_status_id:'',
            'status_title'          => $this->payment_status->title?$this->payment_status->title:'',
            'color_code'        => $this->payment_status->color?$this->payment_status->color:'',
            'total_late'        => $total_late,
            'waiv_penalty'      => $this->waiv_penalty

        ];
    }
}
