<?php

namespace App\Http\Resources;

use App\Repository\AccReceivableDetailPaidRepository as AccPaidRe;
use App\Repository\LoanBalanceAmountRepository as loanBalanceRe;
use Illuminate\Http\Resources\Json\JsonResource;

class SummaryResource extends JsonResource
{
    public function toArray($request)
    {

        return [
            'id'        => $this->id,
            'co_id'      => $this->id,
            'code'      => $this->code,
            'co_name'      => $this->name,
            'client_active'      => $this->client_active,

            'sum_principal'      => $this->sum_principals,
            'sum_interest'      => $this->sum_interests,
            'sum_risk'      => $this->sum_risks,
            'sum_maintenance'      => $this->sum_maintenances,

            // 'paid_principal'      => $this->paid_principal,
            // 'paid_interest'      => $this->paid_interest,
            // 'paid_risk'      => $this->paid_risk,
            // 'paid_maintenance'      => $this->paid_maintenance,

            'paid_principal'    => AccPaidRe::paidPrincipal($this->id),
            'paid_interest'     => AccPaidRe::paidInterest($this->id),
            'paid_maintenance'  => AccPaidRe::paidMaintenance($this->id),
            'paid_risk'            => AccPaidRe::paidRisk($this->id),


            // 'balance_principal'      => $this->balance_principal,
            // 'balance_interest'      => $this->balance_interest,
            // 'balance_risk'      => $this->balance_risk,
            // 'balance_maintenance'      => $this->balance_maintenance,

            'balance_principal'      => loanBalanceRe::getBalancePrincipals($this->id),
            'balance_interest'      => loanBalanceRe::balanceinterest($this->id),
            'balance_risk'      => loanBalanceRe::balanceisk($this->id),
            'balance_maintenance'      => loanBalanceRe::balancemaintenance($this->id),


            'count_day_late'      => $this->count_day_late['late'],
            'amount_day_late'      => $this->count_day_late['amount']

            // 'count_day_late'      => loanBalanceRe::getLoanLates($this->id),
            // 'amount_day_late'      => loanBalanceRe::getLoanLates($this->id),
            // 'amount_day_late'      => loanBalanceRe::getLoanLates($this->id),
        ];
    }
}
