<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'        => $this->id,
            'code'      => $this->code,
            'name'      => $this->name,
            'nickname'  => $this->nickname,
            'gender'    => $this->gender,
            'address'   => $this->address,
            'contact_number' => $this->contact_number,
            'email'     => $this->email,
            'role'      => $this->roles->first()->name??'',
            'role_id'   => $this->roles->first()->id??'',
            'position_name'  => $this->position->name??'',
            'photo'      => $this->photo,
            'attach_file' => $this->attach_file,
            'type'      => $this->type,
            'status' => $this->status,
            'type_document'      => $this->type_document,
            'id_card'      => $this->id_card,
            'date_of_birth'      => $this->date_of_birth,
            'place_of_birth'      => $this->place_of_birth,
            'create_card_date'      => $this->create_card_date,
            'expired_card_date'      => $this->expired_card_date,
            'date_start_working'      => $this->date_start_working,
            'institution'      => $this->institution,
            'position'      => $this->position,
            'work_place'      => $this->work_place,
            'created_at'=> $this->created_at,
            'updated_at'=> $this->updated_at,
            'province_id'=> $this->province_id,
            'district_id'=> $this->district_id,
            'commune_id'=> $this->commune_id,
            'village_id'=> $this->village_id,
            'province_km'=> $this->province->full_name_km??'',
            'district_km'=> $this->district->full_name_km??'',
            'commune_km'=> $this->commune->full_name_km??'',
            'village_km'=> $this->village->full_name_km??'',
            'created_at'=> $this->created_at,
            'updated_at'=> $this->updated_at

        ];

    }
}
