<?php

namespace App\Models;

use App\Helpers\CustomDateFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;
use Spatie\Activitylog\Traits\LogsActivity;

class AccReceivableDetails extends Model
{
    use SoftDeletes;
    protected $table = 'acc_receivable_details';
    protected $fillable = [
        'id','branch_id','loan_id','client_id','co_id','currency_id','acc_id','closing_date','closing_by','approved_by','payment_method','waiv_penalty',
    ];
    public function acc_receivable()
    {
        return $this->belongsTo(AccReceivables::class, 'acc_id');
    }
    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }
    public function co()
    {
        return $this->belongsTo(User::class, 'co_id');
    }
    public function loan()
    {
        return $this->belongsTo(Loan::class, 'loan_id');
    }
    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }
    public function gettotalprincipalAttribute()
    {
        if(request()->date)
        {
            return $this->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date ?? CustomDateFilter::thisDay())
            ->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('paid_principal');
        }
        else
        {
            return $this->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('paid_principal');
        }

    }
    public function gettotalinterestAttribute()
    {
        if(request()->date)
        {
            return $this->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date ?? CustomDateFilter::thisDay())
            ->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('paid_interest');
        }
        else
        {
            return $this->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('paid_interest');
        }
    }
    public function gettotalriskAttribute()
    {
        if(request()->date)
        {
            return $this->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date ?? CustomDateFilter::thisDay())
            ->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('paid_risk');
        }
        else
        {
            return $this->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('paid_risk');
        }
    }
    public function gettotalmaintenanceAttribute()
    {
        if(request()->date)
        {
            return $this->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date ?? CustomDateFilter::thisDay())
            ->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('paid_maintenance');
        }
        else
        {
            return $this->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('paid_maintenance');
        }
    }
    public function gettotalreceivedAttribute()
    {
        if(request()->date)
        {
            return $this->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date ?? CustomDateFilter::thisDay())
            ->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('received');
        }
        else
        {
            return $this->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('received');
        }
    }
    public function gettotalunreceivedAttribute()
    {
        if(request()->date)
        {
            return $this->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date ?? CustomDateFilter::thisDay())
            ->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('unreceived');
        }
        else
        {
            return $this->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('unreceived');
        }
    }
    public function gettotalpenaltyAttribute()
    {
        if(request()->date)
        {
            return $this->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date ?? CustomDateFilter::thisDay())
            ->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('paid_penalty');
        }
        else
        {
            return $this->where('acc_id',$this->acc_id)->where('id',$this->id)->sum('paid_penalty');
        }
    }
}
