<?php

namespace App\Models;

use App\Helpers\Helper;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class AccReceivables extends Model
{
    use SoftDeletes;
    protected $fillable = [
      'id','loan_id','client_id','co_id', 'branch_id', 'currency_id','payment_status_id'
      ,'principal','interest_per_month','risk_per_month', 'maintenance_per_month', 'payment_per_month', 'num','payment_date'
      ,'received_date','loan_balance','penalty', 'received', 'unreceived','payment_date','open_close','waiv_penalty'
  ];
  // protected $logAttributes = [
  //     'id','loan_id','client_id','co_id', 'branch_id', 'currency_id','payment_status_id'
  //     ,'principal','interest_per_month','risk_per_month', 'payment_per_month', 'num','payment_date'
  //     ,'received_date','loan_balance','penalty', 'received', 'unreceived','payment_date','open_close'
  // ];
    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }
    public function loan()
    {
        return $this->belongsTo(Loan::class, 'loan_id');
    }
    public function payment_status()
    {
        return $this->belongsTo(PaymentStatus::class, 'payment_status_id');
    }
    public function co()
    {
        return $this->belongsTo(User::class, 'co_id');
    }

    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }
    public function countlate()
    {
      return AccReceivables::where('loan_id',$this->loan_id)->whereIn('payment_status_id',[2,3])->count();
    }

    // public function getprincipallateAttribute()
    // {
    //   $AccReceivables = AccReceivables::where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d'))
    //       ->where('loan_id',$this->loan_id)
    //       ->whereIn('payment_status_id',[2,3])
    //       ->sum('principal');
    //   $Detail = AccReceivables::leftjoin('acc_receivable_details','acc_receivable_details.acc_id','acc_receivables.id')
    //       ->where(DB::raw("DATE_FORMAT(acc_receivables.payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d'))
    //       ->where('acc_receivables.loan_id',$this->loan_id)
    //       ->whereIn('acc_receivables.payment_status_id',[2,3])
    //       ->sum('acc_receivable_details.paid_principal');
    //   return $AccReceivables-$Detail;
    // }

    // public function getinterestlateAttribute()
    // {
    //   $AccReceivables = AccReceivables::where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d'))
    //       ->where('loan_id',$this->loan_id)
    //       ->whereIn('payment_status_id',[2,3])
    //       ->sum('interest_per_month');
    //   $Detail = AccReceivables::leftjoin('acc_receivable_details','acc_receivable_details.acc_id','acc_receivables.id')
    //       ->where(DB::raw("DATE_FORMAT(acc_receivables.payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d'))
    //       ->where('acc_receivables.loan_id',$this->loan_id)
    //       ->whereIn('acc_receivables.payment_status_id',[2,3])
    //       ->sum('acc_receivable_details.paid_interest');
    //   return $AccReceivables-$Detail;
    // }
    // public function getrisklateAttribute()
    // {
    //   $AccReceivables = AccReceivables::where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d'))
    //       ->where('loan_id',$this->loan_id)
    //       ->whereIn('payment_status_id',[2,3])
    //       ->sum('risk_per_month');
    //   $Detail = AccReceivables::leftjoin('acc_receivable_details','acc_receivable_details.acc_id','acc_receivables.id')
    //       ->where(DB::raw("DATE_FORMAT(acc_receivables.payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d'))
    //       ->where('acc_receivables.loan_id',$this->loan_id)
    //       ->whereIn('acc_receivables.payment_status_id',[2,3])
    //       ->sum('acc_receivable_details.paid_risk');
    //   return $AccReceivables-$Detail;
    // }
    // public function getmaintenancelateAttribute()
    // {
    //   $AccReceivables = AccReceivables::where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d'))
    //       ->where('loan_id',$this->loan_id)
    //       ->whereIn('payment_status_id',[2,3])
    //       ->sum('maintenance_per_month');
    //   $Detail = AccReceivables::leftjoin('acc_receivable_details','acc_receivable_details.acc_id','acc_receivables.id')
    //       ->where(DB::raw("DATE_FORMAT(acc_receivables.payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d'))
    //       ->where('acc_receivables.loan_id',$this->loan_id)
    //       ->whereIn('acc_receivables.payment_status_id',[2,3])
    //       ->sum('acc_receivable_details.paid_maintenance');
    //   return $AccReceivables-$Detail;
    // }
    // public function getreceivedlateAttribute()
    // {
    //   return $this->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d'))->where('loan_id',$this->loan_id)->whereIn('payment_status_id',[2,3])->sum('received');
    // }
    // public function getunreceivedlateAttribute()
    // {
    //   return $this->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d'))->where('loan_id',$this->loan_id)->whereIn('payment_status_id',[2,3])->sum('unreceived');
    // }
    public function getdatelateAttribute()
    {
        return $this->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d'))
          ->where('loan_id',$this->loan_id)
          ->whereIn('payment_status_id',[2,3])
          ->min('payment_date');

    }
    public function gettotallateAttribute()
    {
      $now = Carbon::now();
      $end = Carbon::parse($this->date_late);
      $total_late = $now->diff($end)->days;
      return $total_late;
    }
    // public function getTotalBalancePrincipalsAttribute()
    // {
    //     // return Loan::whereIn('branch_id',Helper::byBranch())
    //     //     ->where('currency_id',Helper::byCurrency())
    //     //     ->whereNotIn('loan_status_id',[1,4,6])
    //     //     ->whereHas('co', function ($query) {
    //     //         $query->where('status',1);
    //     //     })
    //     //     ->whereHas('client', function ($query) {
    //     //         $query->where('status',1);
    //     //     })
    //     //     ->sum('balance_principal');

    //     $currency = Helper::byCurrency();
    //     $branches = Helper::byBranch();
    //     return DB::table('loans')->selectRaw('SUM(loans.balance_principal)')
    //         ->leftjoin('users', 'loans.co_id', '=', 'users.id')
    //         ->leftjoin('clients', 'loans.client_id', '=', 'clients.id')
    //         ->where('users.status',1)
    //         ->where('clients.status',1)
    //         ->whereIn('loans.branch_id', $branches)
    //         ->where('loans.currency_id', $currency) // FIXED: Changed back to where()
    //         ->whereNotIn('loans.loan_status_id',[1,4,6])->get();
    // }

}
