<?php

namespace App\Models\Accounting;

use App\Models\User;
use App\Traits\JsonConvert;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class Depreciation extends Model
{
    use HasFactory, SoftDeletes, LogsActivity,JsonConvert;
    protected $table = 'depreciations';
    protected $fillable = [
        'id','asset_id','branch_id','currency_id','created_by','chart_asset','chart_expense','depreciation_date','period','total_amount','total_paid','balance','desc'
    ];
    protected static $logAttributes = [
        'id','asset_id','branch_id','currency_id','created_by','chart_asset','chart_expense','depreciation_date','period','total_amount','total_paid','balance','desc'
    ];
    protected static $recordEvents = ['deleted', 'created', 'updated'];
    protected static $logName = 'Depreciation Model';
    protected static $logOnlyDirty = true;
    public function getDescriptionForEvent(string $eventName): string
    {
        return "This Depreciation has been {$eventName}";
    }
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->ip = request()->ip();
        $activity->agent = request()->header('user-agent');
    }

    public function scopeSearch($query, $searchText)
    {
        if(isset($searchText)){
            $query->Where("desc","LIKE","$searchText%");
            $query->orWhereHas("assets",function($q) use($searchText){
                $q->where("name","LIKE","$searchText%");
            });
            $query->orWhereHas("chartAsset",function($q) use($searchText){
                $q->where("chart_name","LIKE","$searchText%");
            });
            $query->orWhereHas("chartAsset",function($q) use($searchText){
                $q->where("chart_code","LIKE","$searchText%");
            });
            $query->orWhereHas("chartExpense",function($q) use($searchText){
                $q->where("chart_name","LIKE","$searchText%");
            });
            $query->orWhereHas("chartExpense",function($q) use($searchText){
                $q->where("chart_code","LIKE","$searchText%");
            });
            $query->orWhereHas("createdBy",function($q) use($searchText){
                $q->where("name","LIKE","$searchText%");
            });
        }
        return $query;
    }

    public function assets()
    {
        return $this->belongsTo(Asset::class, 'asset_id','id');
    }

    public function chartAsset()
    {
        return $this->belongsTo(ChartOfAccount::class, 'chart_asset','id');
    }

    public function chartExpense()
    {
        return $this->belongsTo(ChartOfAccount::class, 'chart_expense','id');
    }

    public function depreciationDetail()
    {
        return $this->hasMany(DepreciationDetail::class,'dep_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
