<?php

namespace App\Models\Accounting;

use Illuminate\Database\Eloquent\Model;

class DepreciationDetail extends Model
{
    protected $table = 'depreciation_details';
    protected $fillable = [
        'id',
        'dep_id',
        'payment_date',
        'paid_date',
        'amount',
        'paid',
        'unpaid',
        'loan_balance',
        'status',
        'branch_id',
        'currency_id',
    ];

    public function depreciation()
    {
        return $this->belongsTo(Depreciation::class,'dep_id','id');
    }
}
