<?php

namespace App\Models\Accounting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class TypeOfAccount extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'type_of_accounts';
    protected $fillable = [
        'id',
        'type_name',
        'desc',
        'deleted_at',
        'created_at',
        'updated_at',
    ];
    protected static $logAttributes = [
        'id',
        'type_name',
        'desc',
        'deleted_at',
        'created_at',
        'updated_at',
    ];

    protected static $recordEvents = ['deleted', 'created', 'updated'];
    protected static $logName = 'TypeOfAccount Model';
    protected static $logOnlyDirty = true;
    public function getDescriptionForEvent(string $eventName): string
    {
        return "This TypeOfAccount has been {$eventName}";
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->ip = request()->ip();
        $activity->agent = request()->header('user-agent');
    }

    public function scopeSearch($query,$searchText)
    {
        if(isset($searchText)){
            $query->TypeName($searchText);
        }
        return $query;
    }

    public function scopeTypeName($query,$searchText)
    {
        return $query->where("type_name","LIKE","$searchText%");
    }
    
    public function typeOfAccDetail()
    {
        return $this->hasMany(TypeOfAccDetail::class,'type_of_acc_id');
    }
}
