<?php

namespace App\Models;

use Collator;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class Category extends Model
{
    use SoftDeletes, LogsActivity;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id','title','purpose'
    ];
    protected $logAttributes = [
        'id','title','purpose'
    ];
    public function userAttachment()
    {
        return $this->hasMany(UserAttachment::class, 'user_id');
    }
    protected static $recordEvents = ['deleted', 'created', 'updated'];
    protected static $logName = 'Category Model';
    protected static $logOnlyDirty = true;

    public function getDescriptionForEvent(string $eventName): string
    {
        return "This user has been {$eventName}";
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->ip = request()->ip();
        $activity->branch_id = Auth::user()->branch_id;
        $activity->agent = request()->header('user-agent');
    }
}
