<?php

namespace App\Models;

use App\Models\Commune;
use App\Models\Village;
use App\Models\District;
use App\Models\Province;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model
{
    use SoftDeletes, LogsActivity;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name','code','branch_id', 'gender', 'type_document', 'id_card', 'date_of_birth', 'issued_by', 'place_of_birth',
        'create_card_date', 'expired_card_date','created_by', 'phone', 'photo', 'work_place', 'relationship','address',
        'status','job', 'house', 'position', 'province_id','district_id', 'commune_id', 'village_id', 'village_kh','institution',
        'name_en','income','expense','balance','remark'
    ];
    protected $logAttributes = [
        'name','code','branch_id', 'gender', 'type_document', 'id_card', 'date_of_birth', 'issued_by', 'place_of_birth',
        'create_card_date', 'expired_card_date','created_by', 'phone', 'photo', 'work_place', 'relationship','address',
        'status','job', 'house', 'position', 'province_id','district_id', 'commune_id', 'village_id', 'village_kh','institution','name_en',
        'income','expense','balance','remark'
    ];

    public function userAttachment()
    {
        return $this->hasMany(UserAttachment::class, 'user_id');
    }

    public function village()
    {
        return $this->belongsTo(Village::class, 'village_id');
    }

    public function commune()
    {
        return $this->belongsTo(Commune::class, 'commune_id');
    }

    public function district()
    {
        return $this->belongsTo(District::class, 'district_id');
    }

    public function province()
    {
        return $this->belongsTo(Province::class, 'province_id');
    }

    public function clientHasLoan()
    {
        return $this->hasMany(Loan::class, 'client_id');
    }

    protected static $recordEvents = ['deleted', 'created', 'updated'];
    protected static $logName = 'Client Model';
    protected static $logOnlyDirty = true;

    public function getDescriptionForEvent(string $eventName): string
    {
        return "This user has been {$eventName}";
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->ip = request()->ip();
        $activity->branch_id = Auth::user()->branch_id;
        $activity->agent = request()->header('user-agent');
    }
}
