<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class Collateral extends Model
{
    use SoftDeletes, LogsActivity;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id','cat_id','title','purpose','status'
    ];
    protected $logAttributes = [
        'id','cat_id','title','purpose','status'
    ];
    public function userAttachment()
    {
        return $this->hasMany(UserAttachment::class, 'user_id');
    }
    protected static $recordEvents = ['deleted', 'created', 'updated'];
    protected static $logName = 'Collateral Model';
    protected static $logOnlyDirty = true;

    public function getDescriptionForEvent(string $eventName): string
    {
        return "This user has been {$eventName}";
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->ip = request()->ip();
        $activity->branch_id = Auth::user()->branch_id;
        $activity->agent = request()->header('user-agent');
    }
    public function category()
    {
        return $this->belongsTo(Category::class,'cat_id');
    }
}
